package Direct::AdGroups2::Performance;

use Direct::Modern;
use Mouse;

extends 'Direct::AdGroups2';

use Settings;

use Direct::Model::AdGroupPerformance::Manager;

has '+items' => (isa => 'ArrayRef[Direct::Model::AdGroupPerformance]');

=head2 manager_class
=cut

sub manager_class { 'Direct::Model::AdGroupPerformance::Manager' }

=head2 get($adgroup_ids, %options)

Аналогичен Direct::AdGroups2->get с adgroup_type => 'performance'.

=cut

sub get {
    my ($class, $adgroup_ids, %options) = @_;
    $class->SUPER::get($adgroup_ids, %options, adgroup_type => 'performance');
}

=head2 get_by($key, $vals, %options)

Аналогичен Direct::AdGroups2->get_by с adgroup_type => 'performance'.

=cut

sub get_by {
    my ($class, $key, $vals, %options) = @_;
    $class->SUPER::get_by($key, $vals, %options, adgroup_type => 'performance');
}

=head2 create($uid)

Создание списка групп перфоманс объявлений в БД для пользователя $uid.

=cut

sub create {
    my ($self, $uid) = @_;

    $self->set_client_id_by_uid($uid);
    $self->prepare_create($uid);
    $self->prepare_logging('create', uid => $uid);
    $self->manager->create();
    $self->do_logging();

    return;
}

=head2 prepare_update(%options)

Подготовка списка групп перфоманс объявлений к обновлению.
%options унаследованы от родительского метода.

=cut

sub prepare_update {
    my ($self, %options) = @_;

    $self->SUPER::prepare_update(%options);

    for my $adgroup (@{$self->items}) {
        if ($adgroup->is_field_to_use_as_name_changed || $adgroup->is_field_to_use_as_body_changed) {
            $adgroup->status_bs_synced('No');
        }

        # Сброс statusBsSynced означает, что нужно также сбросить этот статус на всех баннерах в группе
        if ($adgroup->is_status_bs_synced_changed && $adgroup->status_bs_synced eq 'No') {
            $adgroup->do_bs_sync_banners(1);
        }
        if ($adgroup->is_geo_changed){
            $adgroup->do_set_geo_for_draft_creatives({translocal_opt => $options{translocal_opt} // {ClientID => $adgroup->client_id}});
        }
        # feed_id не меняется
        croak "Cannot change feed_id on performance adgroup" if $adgroup->is_feed_id_changed;
    }

    return $self;
}

=head2 update($uid, %options)

Обновление списка групп динамических объявлений в БД для пользователя $uid.
%options аналогичны prepare_update.

=cut

sub update {
    my ($self, $uid, %options) = @_;

    $self->set_client_id_by_uid($uid);
    $self->prepare_update(%options);
    $self->prepare_logging('update', uid => $uid);
    $self->manager->update();
    $self->do_logging();

    return;
}

1;
