package Direct::AdGroups2::Smart;
use Direct::Modern;

use Mouse;
with 'Direct::Role::ValidationResultConsumer';

use Settings;

use Yandex::DBTools;
use Yandex::I18n;
use Yandex::HashUtils qw/hash_cut hash_merge/;
use Yandex::ListUtils qw/xuniq/;
use Yandex::URL qw/get_host/;
use Yandex::Trace;
use List::MoreUtils qw/any all each_array part/;
use Scalar::Util qw/blessed/;
use Storable qw/dclone/;

use CampaignTools;
use User qw//;
use MinusWords qw//;
use TextTools qw/smartstrip2/;
use Tag qw//;
use VCards qw//;
use Sitelinks qw//;
use URLDomain qw//;
use PrimitivesIds qw/get_clientid/;
use Models::Campaign qw//;
use PhraseText qw//;
use Direct::PhraseTools qw/polish_phrase_text/;
use BS::History qw//;
use PlacePrice qw//;
use Direct::Validation::Errors;

use Direct::Model::Client;
use Direct::Model::Campaign;
use Direct::Model::CampaignCpmDeals;
use Direct::Model::AdGroupText;
use Direct::Model::AdGroupDynamic;
use Direct::Model::AdGroupMobileContent;
use Direct::Model::AdGroupPerformance;
use Direct::Model::AdGroupMcbanner;
use Direct::Model::AdGroupCpmBanner;
use Direct::Model::AdGroupCpmVideo;
use Direct::Model::BannerText;
use Direct::Model::BannerDynamic;
use Direct::Model::BannerMobileContent;
use Direct::Model::BannerPerformance;
use Direct::Model::BannerImage;
use Direct::Model::BannerCreative;
use Direct::Model::BannerMcbanner;
use Direct::Model::BannerCpmBanner;
use Direct::Model::Image;
use Direct::Model::Keyword;
use Direct::Model::DynamicCondition;
use Direct::Model::PerformanceFilter;
use Direct::Model::PerformanceFilter::Rule;
use Direct::Model::Pixel;
use Direct::Model::Pixel::Utils;
use Direct::Model::Retargeting;
use Direct::Model::RetargetingCondition;
use Direct::Model::TargetInterest;
use Direct::Model::VCard;
use Direct::Model::VCard::Manager;
use Direct::Model::Sitelink;
use Direct::Model::SitelinksSet;
use Direct::Model::SitelinksSet::Manager;
use Direct::Model::AdditionsItemCallout;
use Direct::Model::User;
use Direct::Model::BannerImage::Role::Url qw//;
use Direct::Model::Banner::Constants;

use Direct::Campaigns;
use Direct::AdGroups2::Text;
use Direct::AdGroups2::Dynamic;
use Direct::AdGroups2::MobileContent;
use Direct::AdGroups2::Performance;
use Direct::AdGroups2::Mcbanner;
use Direct::AdGroups2::CpmBanner;
use Direct::AdGroups2::CpmVideo;
use Direct::Banners::Text;
use Direct::Banners::ImageAd;
use Direct::Banners::CpcVideo;
use Direct::ImageFormats;
use Direct::Banners::Dynamic;
use Direct::Banners::MobileContent;
use Direct::Banners::Performance;
use Direct::Banners::Mcbanner;
use Direct::Banners::CpmBanner;
use Direct::Keywords;
use Direct::Bids::BidRelevanceMatch;
use Direct::DynamicConditions;
use Direct::PerformanceFilters;
use Direct::Retargetings;
use Direct::RetargetingConditions;
use Direct::TargetInterests;
use Direct::Creatives;
use Direct::VCards;
use Direct::BsData;
use Direct::VideoAdditions;
use Direct::BannersCreatives;

use Direct::Retargetings qw/
    validate_socdem_retargetings_for_cpm_adgroup
    save_socdem_retargetings_for_cpm_adgroup
/;

use Direct::Validation::AdGroupsText qw/
    validate_add_text_adgroups
    validate_update_text_adgroups
    validate_add_banners_text_adgroup
    validate_update_banners_text_adgroup
/;
use Direct::Validation::AdGroupsDynamic qw/
    validate_add_dynamic_adgroups
    validate_update_dynamic_adgroups
    validate_add_banners_dynamic_adgroup
    validate_update_banners_dynamic_adgroup
/;
use Direct::Validation::AdGroupsMobileContent qw/
    validate_add_mobile_adgroups
    validate_update_mobile_adgroups
    validate_add_banners_mobile_adgroup
    validate_update_banners_mobile_adgroup
/;
use Direct::Validation::AdGroupsPerformance qw/
    validate_add_performance_adgroups
    validate_update_performance_adgroups
    validate_add_banners_performance_adgroup
    validate_update_banners_performance_adgroup
/;
use Direct::Validation::AdGroupsMcbanner qw/
    validate_add_mcbanner_adgroups
    validate_update_mcbanner_adgroups
    validate_add_banners_mcbanner_adgroup
    validate_update_banners_mcbanner_adgroup
/;
use Direct::Validation::AdGroupsCpmBanner qw/
    validate_add_cpm_banner_adgroups
    validate_update_cpm_banner_adgroups
    validate_add_banners_cpm_banner_adgroup
    validate_update_banners_cpm_banner_adgroup
/;
use Direct::Validation::BannersPerformance qw/
    validate_delete_performance_banners
    validate_video_additions_layout_id
/;
use Direct::Validation::Keywords qw/
    validate_keywords_for_adgroup
/;
use Direct::Validation::Bids qw/
    validate_relevance_matches_for_adgroup
/;
use Direct::Validation::Retargetings qw/
    validate_retargetings_for_adgroup
/;
use Direct::Validation::TargetInterests qw/
    validate_target_interests_for_adgroup
    /;
use Direct::Validation::DynamicConditions qw/
    validate_dynamic_conditions_for_adgroup
/;
use Direct::Validation::PerformanceFilters qw/
    validate_performance_filters_for_adgroup
/;

use Direct::Validation::VCards qw/validate_vcards/;
use Direct::Validation::SitelinksSets qw/validate_sitelinks_sets/;

use Direct::Model::RetargetingCondition::Goal::Constants;

# Main params
has 'client_id'    => (is => 'rw', isa => 'Id');
has 'chief_uid'    => (is => 'ro', isa => 'Id');
has 'operator_uid' => (is => 'ro', isa => 'Id');
has 'campaign_id'  => (is => 'ro', isa => 'Id');

# Options
has 'save_as_draft'           => (is => 'rw', isa => 'Bool', default => 0);
has 'replace_show_conditions' => (is => 'rw', isa => 'Bool', default => 0);
has 'post_moderate'           => (is => 'rw', isa => 'Bool', default => 0);

# Internal data
has '_user_adgroups'        => (is => 'ro', isa => 'ArrayRef[HashRef]');
has 'client'                => (is => 'rw', isa => 'Direct::Model::Client');
has 'user'                  => (is => 'rw', isa => 'Direct::Model::User');
has 'campaign'              => (is => 'rw', isa => 'HashRef');
has '_campaign_tag_id2name' => (is => 'rw', isa => 'HashRef');

has '_ex_adgroup_by_id'             => (is => 'rw', isa => 'HashRef');
has '_ex_banners_by_gid'            => (is => 'rw', isa => 'HashRef');
has '_ex_keywords_by_gid'           => (is => 'rw', isa => 'HashRef');
has '_ex_relevance_matches_by_gid'    => (is => 'rw', isa => 'HashRef');
has '_ex_retargetings_by_gid'       => (is => 'rw', isa => 'HashRef');
has '_ex_target_interests_by_gid'   => (is => 'rw', isa => 'HashRef');
has '_ex_ret_cond_by_id'            => (is => 'rw', isa => 'HashRef');
has '_ex_dyn_conds_by_gid'          => (is => 'rw', isa => 'HashRef', builder => sub {+{}});
has '_ex_perf_filters_by_gid'       => (is => 'rw', isa => 'HashRef');
has '_ex_creative_by_id'            => (is => 'rw', isa => 'HashRef');
has '_ex_creative_canvas_by_id'     => (is => 'rw', isa => 'HashRef');
has '_ex_format_by_hash'            => (is => 'rw', isa => 'HashRef');
has '_ex_video_resource_by_id'      => (is => 'rw', isa => 'HashRef');
has '_gen_video_resource_by_id'     => (is => 'rw', isa => 'HashRef');
has _ex_feed_by_id                  => (is => 'rw', isa => 'HashRef');
has _ex_banner_creatives_by_id      => (is => 'rw', isa => 'HashRef');
has _ex_turbolandings               => (is => 'rw', isa => 'HashRef');

# Data to save
has '_data_to_apply' => (is => 'ro', isa => 'ArrayRef[HashRef]', lazy => 1, default => sub { [] });

# баннеры, которые созданы в результате работы apply
has 'new_banners' => ( is => 'rw', isa => 'ArrayRef[Direct::Model::Banner]', default => sub{[]} );

=head2 is_text_campaign
=head2 is_dynamic_campaign
=head2 is_mobile_content_campaign
=head2 is_performance_campaign
=head2 is_mcbanner_campaign
=head2 is_cpm_banner_campaign
=head2 is_cpm_deals_campaign

Возвращает истинное значение для кампании соответствующего типа

=cut

sub is_text_campaign { $_[0]->campaign->{type} eq 'text' }
sub is_dynamic_campaign { $_[0]->campaign->{type} eq 'dynamic' }
sub is_mobile_content_campaign { $_[0]->campaign->{type} eq 'mobile_content' }
sub is_performance_campaign { $_[0]->campaign->{type} eq 'performance' }
sub is_mcbanner_campaign { $_[0]->campaign->{type} eq 'mcbanner' }
sub is_cpm_banner_campaign { $_[0]->campaign->{type} eq 'cpm_banner' }
sub is_cpm_deals_campaign { $_[0]->campaign->{type} eq 'cpm_deals' }

=head2 from_user_data($chief_uid, $cid, $user_adgroups, %params)

Подготовка пользовательских данных: создание моделей и загрузка данных.

=cut

sub from_user_data {
    my ($class, $chief_uid, $cid, $user_adgroups, %params) = @_;

    my $profile = Yandex::Trace::new_profile('smart:from_user_data');

    $params{operator_uid} = delete $params{UID} if exists $params{UID};
    for (keys %params) {
        croak "Unknown param: $_" unless /^(?:save_as_draft|replace_show_conditions|post_moderate|operator_uid|campaign|mk_fake_canvas_creatives)$/;
    }

    my $client_id = get_clientid(uid => $chief_uid);
    my $self = $class->new(
        client_id       => $client_id,
        chief_uid       => $chief_uid,
        operator_uid    => $params{operator_uid} || 0,
        campaign_id     => $cid,
        _user_adgroups  => dclone($user_adgroups),
        %{hash_cut(\%params, qw/save_as_draft replace_show_conditions post_moderate/)},
    );

    if (!@$user_adgroups) {
        $self->_add_error(iget('Ошибка! Группы не найдены.'));
        return $self;
    }

    $user_adgroups = $self->_user_adgroups;

    # Загрузим данные по главному представителю
    my $user_row = User::get_user_data($chief_uid, [qw/uid tags_allowed/]);
    $user_row->{tags_allowed} //= 'No';
    $self->user(Direct::Model::User->from_db_hash($user_row, \{}));

    # Загрузим данные по клиенту
    my $client_row = (sub {
        my @select_columns = map { Direct::Model::Client->get_db_columns(@$_, prefix => '') } ([clients => 'cl'], [client_limits => 'clim']);
        my @from_tables = ('clients cl', 'LEFT JOIN client_limits clim ON (clim.ClientID = cl.ClientID)');
        my $row = get_one_line_sql(PPC(ClientID => $self->client_id), [
            sprintf('SELECT %s FROM %s', join(', ', @select_columns), join(' ', @from_tables)),
            where => {'cl.ClientID' => $self->client_id},
        ]);
        $row->{work_currency} //= 'YND_FIXED';
        $row->{camp_count_limit} ||= $Settings::DEFAULT_CAMP_COUNT_LIMIT;
        $row->{unarc_camp_count_limit} ||= $Settings::DEFAULT_UNARC_CAMP_COUNT_LIMIT;
        $row->{banner_count_limit} ||= $Settings::DEFAULT_BANNER_COUNT_LIMIT;
        $row->{keyword_count_limit} ||= $Settings::DEFAULT_KEYWORD_COUNT_LIMIT;
        $row->{video_blacklist_size_limit} ||= $Settings::DEFAULT_VIDEO_BLACKLIST_SIZE_LIMIT;
        return $row;
    })->();
    $self->client(Direct::Model::Client->from_db_hash($client_row, \{}));

    # Загрузим данные по кампании
    my $campaign;
    if (!$cid) {
        # Возможно, кампания новая
        croak 'Please, provide campaign id or data' if !$params{campaign};
        $campaign = dclone($params{campaign});
        $campaign->{archived} //= 'No';
        $campaign->{statusModerate} //= 'New';
        $campaign->{currency} //= 'YND_FIXED';
        $campaign->{type} //= delete($campaign->{mediaType}) // delete($campaign->{campaign_type});
        croak 'Please, provide campaign type' if !$campaign->{type};
    } else {
        $campaign = Models::Campaign::get_user_camp_gr($chief_uid, $cid, {no_groups => 1, detailed_retargeting_warnings => 1, without_multipliers => 1});
        if (!defined $campaign) {
            $self->_add_error(iget('Ошибка! Неправильный номер кампании или логин (повторно залогиньтесь).'));
            return $self;
        }
    }
    $self->campaign($campaign);

    # Нельзя сохранить изменения в архивной кампании
    if ($campaign->{archived} eq 'Yes') {
        $self->_add_error(iget('Изменения не могут быть сохранены, поскольку кампания №%d перенесена в архив.', $cid));
        return $self;
    }

    # Если кампания черновик, то и объекты сохраняем как черновики
    $self->save_as_draft(1) if $campaign->{statusModerate} eq 'New';

    #
    # Преобразование полей пользовательских данных из старого формата в новый + подготовка
    #
    for my $user_adgroup (@$user_adgroups) {
        $user_adgroup->{adgroup_id} //= delete($user_adgroup->{gid}) // delete($user_adgroup->{pid});
        $user_adgroup->{adgroup_name} //= delete($user_adgroup->{group_name}) if exists $user_adgroup->{group_name};

        if (exists $user_adgroup->{tags}) {
            my $tags = $user_adgroup->{tags};
            if (ref($tags) eq 'ARRAY' && @$tags && ref($tags->[0]) eq 'HASH') {
                # Передали что-то вида: [{tag_name => "tag1"}, {tag_name => "tag2"}, ...]
                @$tags = map { $_->{tag_name} } @$tags;
            }
        }

        if (my $deleted_bids = $user_adgroup->{deleted_bids}) {
            push @{$user_adgroup->{banners}}, {banner_id => $_, _delete => 1} for @$deleted_bids;
        }

        $_->{banner_id} //= delete($_->{bid}) for @{$user_adgroup->{banners} // []};

        $user_adgroup->{keywords} //= delete($user_adgroup->{phrases}) if exists $user_adgroup->{phrases};

        # Если кампания не указана (cid == 0), то не учитываем никакие идентификаторы в user_adgroups
        if (!$cid) {
            $user_adgroup->{adgroup_id} = 0;
            $_->{banner_id} = 0 for @{$user_adgroup->{banners} // []};
            $_->{hash_flags} = {} for @{$user_adgroup->{banners} // []};
            $_->{id} = 0 for @{$user_adgroup->{keywords} // []};
            $_->{bid_id} = 0 for @{$user_adgroup->{relevance_match} // []};
            $_->{ret_id} = 0 for @{$user_adgroup->{retargetings} // []};
            $_->{ret_id} = 0 for @{$user_adgroup->{target_interests} // []};
            $_->{dyn_id} = 0 for @{$user_adgroup->{dynamic_conditions} // []};
            $_->{perf_filter_id} = 0 for @{$user_adgroup->{performance_filters} // []};
        }
    }
    #
    # Выберем из БД существующие данные
    #
    my @ex_adgroup_ids = grep { $_ } map { $_->{adgroup_id} } @$user_adgroups;
    
    if ($self->is_cpm_banner_campaign || $self->is_cpm_deals_campaign) {
        $self->client->permitted_pixel_providers(Direct::Model::Pixel::Utils::get_permitted_providers_by_campaign_types($self->client_id));
    }

    if ($self->is_text_campaign) {
            $self->_ex_adgroup_by_id(
            Direct::AdGroups2::Text->get(\@ex_adgroup_ids, extended => 1, with_multipliers => 1)->items_by
        );
        $self->_ex_banners_by_gid(
            Direct::Banners::Text->get_by(
                adgroup_id              => \@ex_adgroup_ids,
                with_vcard              => 1,
                with_image              => 1,
                with_sitelinks          => 1,
                with_additions_callouts => 1,
                with_video_resources    => 1,
                with_turbolanding       => 1,
                with_permalinks         => 1,
            )->items_by('gid')
        );
        my $imagead_banners = Direct::Banners::ImageAd->get_by(adgroup_id => \@ex_adgroup_ids, with_turbolanding => 1)->items_by('gid');

        push @{$self->_ex_banners_by_gid()->{$_}}, @{$imagead_banners->{$_}} for keys %$imagead_banners;

        my $cpc_video_banners = Direct::Banners::CpcVideo->get_by(adgroup_id => \@ex_adgroup_ids, with_turbolanding => 1)->items_by('gid');
        
        push @{$self->_ex_banners_by_gid()->{$_}}, @{$cpc_video_banners->{$_}} for keys %$cpc_video_banners;

        $self->_ex_format_by_hash(Direct::ImageFormats->get_by(client_id => $self->client_id)->items_by('hash'));
        
        $self->_load_video_resources($user_adgroups);
        
    } elsif ($self->is_dynamic_campaign) {
        $self->_ex_adgroup_by_id(
            Direct::AdGroups2::Dynamic->get(\@ex_adgroup_ids, extended => 1, with_multipliers => 1)->items_by
        );
        $self->_ex_banners_by_gid(
            Direct::Banners::Dynamic->get_by(adgroup_id => \@ex_adgroup_ids, with_vcard => 1, with_image => 1, with_sitelinks => 1, with_additions_callouts => 1)->items_by('gid')
        );
        $self->_ex_dyn_conds_by_gid(
            Direct::DynamicConditions->get_by(adgroup_id => \@ex_adgroup_ids, with_additional => 1)->items_by('gid')
        );
        $self->_ex_feed_by_id(Direct::Feeds->get_by($self->client_id)->items_by('id'));

        $self->_ex_format_by_hash(Direct::ImageFormats->get_by(client_id => $self->client_id)->items_by('hash'));
    } elsif ($self->is_mobile_content_campaign) {
        $self->_ex_adgroup_by_id(
            Direct::AdGroups2::MobileContent->get(\@ex_adgroup_ids, extended => 1, with_multipliers => 1)->items_by
        );
        $self->_ex_banners_by_gid(
            Direct::Banners::MobileContent->get_by(adgroup_id => \@ex_adgroup_ids, banner_type => 'mobile_content', with_image => 1,
                with_video_resources => 1)->items_by('gid')
        );
        
        $self->_load_video_resources($user_adgroups);

        my $cpc_video_banners = Direct::Banners::CpcVideo->get_by(adgroup_id => \@ex_adgroup_ids, with_turbolanding => 1)->items_by('gid');

        push @{$self->_ex_banners_by_gid()->{$_}}, @{$cpc_video_banners->{$_}} for keys %$cpc_video_banners;

        my $imagead_banners = Direct::Banners::ImageAd->get_by(adgroup_id => \@ex_adgroup_ids, banner_type => 'image_ad')->items_by('gid');

        push @{$self->_ex_banners_by_gid()->{$_}}, @{$imagead_banners->{$_}} for keys %$imagead_banners;

        $self->_ex_format_by_hash(Direct::ImageFormats->get_by(client_id => $self->client_id)->items_by('hash'));

    } elsif ($self->is_performance_campaign) {
        $self->_ex_adgroup_by_id(
            Direct::AdGroups2::Performance->get(\@ex_adgroup_ids, extended => 1, with_multipliers => 1)->items_by
        );
        $self->_ex_banners_by_gid(
            Direct::Banners::Performance->get_by(adgroup_id => \@ex_adgroup_ids)->items_by('gid')
        );
        $self->_ex_perf_filters_by_gid(
            Direct::PerformanceFilters->get_by(adgroup_id => \@ex_adgroup_ids, with_additional => 1)->items_by('gid')
        );
        $self->_ex_feed_by_id(Direct::Feeds->get_by($self->client_id)->items_by('id'));

        # Креативы
        if (my @creative_ids = grep { $_ } map { $_->{creative_id} } map { @{$_->{banners} // []} } @$user_adgroups) {
            my $creatives = Direct::Creatives->get_by(creative_id => \@creative_ids, $chief_uid)->items;
            $self->_ex_creative_by_id(+{ map { $_->id => $_ } @$creatives });
        }
    } elsif ($self->is_mcbanner_campaign) {
        $self->_ex_adgroup_by_id(
            Direct::AdGroups2::Mcbanner->get(\@ex_adgroup_ids, extended => 1, with_multipliers => 1 )->items_by
        );
        $self->_ex_banners_by_gid(
            Direct::Banners::Mcbanner->get_by(adgroup_id => \@ex_adgroup_ids)->items_by('gid')
        );

        $self->_ex_format_by_hash(Direct::ImageFormats->get_by(client_id => $self->client_id)->items_by('hash'));
        # тут будет подгрузка креативов
    } elsif ($self->is_cpm_banner_campaign || $self->is_cpm_deals_campaign) {
        $self->_ex_adgroup_by_id(
            # Direct::AdGroups2::CpmBanner->get(\@ex_adgroup_ids, extended => 1, with_multipliers => 1 )->items_by
            Direct::AdGroups2->get(\@ex_adgroup_ids, extended => 1, with_multipliers => 1, adgroup_type => [qw/cpm_banner cpm_video/] )->items_by
        );
        $self->_ex_banners_by_gid(
            Direct::Banners::CpmBanner->get_by(adgroup_id => \@ex_adgroup_ids, with_turbolanding => 1, with_pixels => 1)->items_by('gid')
        );
    }

    # Ключевые слова
    if ($self->is_text_campaign || $self->is_mobile_content_campaign || $self->is_mcbanner_campaign || $self->is_cpm_banner_campaign || $self->is_cpm_deals_campaign) {
        $self->_ex_keywords_by_gid(
            Direct::Keywords->get_by(adgroup_id => \@ex_adgroup_ids)->items_by('gid')
        );
    }
    # Бесфразный таргетинг
    if ($self->is_text_campaign || $self->is_mobile_content_campaign) {
        $self->_ex_relevance_matches_by_gid(
            Direct::Bids::BidRelevanceMatch->get_by(adgroup_id => \@ex_adgroup_ids)->items_by('gid')
        );
    }
    # Ретаргетинг
    if ($self->is_text_campaign || $self->is_mobile_content_campaign || $self->is_cpm_banner_campaign || $self->is_cpm_deals_campaign) {
        $self->_ex_retargetings_by_gid(
            Direct::Retargetings->get_by(adgroup_id => \@ex_adgroup_ids)->items_by('gid')
        );
        $self->_ex_ret_cond_by_id(
            Direct::RetargetingConditions->get_by(client_id => $self->client_id, fields => [qw/id properties/])->items_by
        );
    }
    # Интересы (TODO DIRECT-67758 не грузить для ТГО)
    if ($self->is_text_campaign || $self->is_mobile_content_campaign) {
        $self->_ex_target_interests_by_gid(
            Direct::TargetInterests->get_by(adgroup_id => \@ex_adgroup_ids)->items_by('gid')
        );
    }
    # canvas-креативы
    if (
        $self->is_text_campaign
        || $self->is_mobile_content_campaign
        || $self->is_cpm_banner_campaign
        || $self->is_cpm_deals_campaign
    ) {

        my @creative_ids =
            grep { $_ }
            map { ($_->{creative}) ? $_->{creative}->{creative_id} : undef }
            map { @{$_->{banners} // []} }
            @$user_adgroups;

        if (@creative_ids) {
            my $creative_types = Direct::Campaigns->get_model_class_by_type($self->campaign->{type})->available_creative_types;
            my $creatives = Direct::Creatives::get_creatives_with_type($creative_types, $chief_uid, \@creative_ids);

            $self->_ex_creative_canvas_by_id(+{ map { $_->id => $_ } @$creatives });

            if ($params{mk_fake_canvas_creatives}) {
                my @ext_creative_ids = map {$_->{creative}->{creative_id}}
                                        grep {$_->{creative} && $_->{creative}{creative_id} && !$_->{skip_image_download}
                                              && !$self->_ex_creative_canvas_by_id()->{$_->{creative}{creative_id}}
                                        }
                                            map { @{$_->{banners} // []} } @$user_adgroups;
                my $fake_creatives = [map {Direct::Model::CanvasCreative->from_db_hash({creative_id => $_, moderate_info => '', width => -1}, \{})} @ext_creative_ids];
                $self->_ex_creative_canvas_by_id()->{$_->id} = $_ foreach @$fake_creatives;
            }
        }
    }

    # Текущие теги на кампании
    $self->_campaign_tag_id2name(
        $cid ? get_hash_sql(PPC(cid => $cid), 'SELECT tag_id, tag_name FROM tag_campaign_list WHERE cid = ?', $cid) : +{}
    );

    #
    # Проверим и подготовим переданные пользователем данные
    #
    for my $user_adgroup (@$user_adgroups) {
        my $adgroup_id = $user_adgroup->{adgroup_id} || 0;

        if ($adgroup_id) {
            my $ex_adgroup = $self->_ex_adgroup_by_id->{$adgroup_id};
            if ($ex_adgroup && !(defined $user_adgroup->{geo} && $user_adgroup->{geo} gt '')) {
                $user_adgroup->{geo} = $ex_adgroup->geo;
                # если взяли geo из базы, то перерасчитывать транслокальность не надо
                $user_adgroup->{geo_is_modified_before_save} = 1;
            }

            if (!$ex_adgroup || $ex_adgroup->campaign_id != $cid) {
                $self->_add_error(iget('Ошибка: группа объявлений №%d не найдена в кампании №%d.', $adgroup_id, $cid));
            }
            elsif ($ex_adgroup->is_archived) {
                $self->_add_error(iget('Ошибка: группа объявлений №%d находится в архиве и не может быть изменена.', $adgroup_id));
            }
        }

        my $ex_banner_by_id = {map { $_->id => $_ } @{$self->_ex_banners_by_gid->{$adgroup_id} // []}};
        for my $user_banner (@{$user_adgroup->{banners} // []}) {

            my $banner_id = $user_banner->{banner_id} || 0;

            if (defined $user_adgroup->{adgroup_type} && $user_adgroup->{adgroup_type} =~ /^text|mobile_content$/ && !$user_banner->{ad_type}) {
                $self->_add_error(iget('Ошибка: не указан тип баннера'), $user_banner);
                next;
            }

            if ($self->is_performance_campaign) {
                # Для перфоманс баннеров - проверим наличие creative_id
                my $creative_id = $user_banner->{creative_id};
                if (
                    (!$creative_id && !$banner_id) ||                               # Не указан креатив для нового баннера
                    ($creative_id && !$self->_ex_creative_by_id->{$creative_id})    # Указан несуществующий креатив
                ) {
                    $self->_add_error(
                        iget('Ошибка: указан некорректный или несуществующий номер креатива (группа №%d, баннер №%d)', $adgroup_id, $banner_id),
                        $user_banner
                    );
                }
            }

            if ($user_banner->{ad_type} && $user_banner->{ad_type} eq 'image_ad') {
                my $image = $self->_ex_format_by_hash->{ ($user_banner->{image_ad} // {})->{hash} };
                if (!$user_banner->{creative} && !defined $user_banner->{image_url} && !($user_banner->{image_ad} && $user_banner->{image_ad}->{hash} && $self->_ex_format_by_hash->{$user_banner->{image_ad}->{hash}})) {
                    # NB: тут кажется баг и не проверять существование хеша в загруженных если его не передал фронт
                    # т.е. что-то типа && ($user_banner->{image_ad} && $user_banner->{image_ad}->{hash} && !$self->_ex_format_by_hash->{$user_banner->{image_ad}->{hash}})
                    $self->_add_error(iget('Изображение не существует или у вас нет к нему доступа'), $user_banner);
                } elsif ($user_banner->{image_ad} && $user_banner->{creative}) {
                    $self->_add_error(iget('Для графического баннера должен быть определен только креатив или только изображение'), $user_banner);
                } elsif (!defined $user_banner->{image_url} && !$user_banner->{image_ad} && !$user_banner->{creative}) {
                    $self->_add_error(iget('Для графического баннера должено быть определено изображение'), $user_banner);
                    # после публичного запуска DIRECT-56873 изменить текста на: $self->_add_error(iget("Для графического баннера должен быть определен креатив или изображение"));
                } elsif (!(defined $user_banner->{image_url} || $user_banner->{image_ad}) && !($user_banner->{creative} && $user_banner->{creative}->{creative_id} && $self->_ex_creative_canvas_by_id->{$user_banner->{creative}->{creative_id}})) {
                    $self->_add_error(iget('Canvas-креатив не существует или у вас нет к нему доступа'));
                } elsif (defined $image && defined $image->{width} && defined $image->{height} &&
                    !Direct::Validation::Image::is_image_size_valid_for_image_ad($image->{width}, $image->{height})) {
                    $self->_add_error(iget("Неверный размер изображения"), $user_banner);
                }
            }

            if (defined $user_banner->{ad_type} && $user_banner->{ad_type} eq 'mcbanner') {
                if ($user_banner->{image_ad}
                    && $user_banner->{image_ad}->{hash}
                    && !$self->_ex_format_by_hash->{ $user_banner->{image_ad}->{hash} }
                    # TODO DIRECT-67003 похоже что это про загрузку через XLS
                    # && !defined $user_banner->{image_url}
                ) {
                    $self->_add_error(iget('Изображение не существует или у вас нет к нему доступа'), $user_banner);
                # } elsif (!defined $user_banner->{image_url} && !$user_banner->{image_ad}) {
                #     # TODO DIRECT-67003 текст ошибки? NB в image_ad оно держится на фронтовой валидации...
                #     $self->_add_error(iget('Для графического баннера должено быть определено изображение'), $user_banner);
                }
            }

            if ($self->is_cpm_banner_campaign || $self->is_cpm_deals_campaign) {
                # Для cpm_banner и cpm_deals проверим наличие creative_id
                my $creative_id = $user_banner->{creative}{creative_id};
                if (!$creative_id) {
                    $self->_add_error(iget('Креатив не указан')) if !$banner_id;
                } elsif (!$self->_ex_creative_canvas_by_id->{$creative_id}) { # Указан несуществующий креатив
                    $self->_add_error(iget('Креатив не существует или у вас нет к нему доступа'));
                }
            }

            next unless $banner_id;

            my $ex_banner = $ex_banner_by_id->{$banner_id};

            # Баннер с идентификатором не может находится в новой группе
            if (!$adgroup_id) {
                $self->_add_error(iget('Ошибка: объявление №%d не может находится в новой группе', $banner_id), $user_banner);
            }
            elsif (!$ex_banner) {
                $self->_add_error(iget('Ошибка: объявление №%d не найдено в группе №%d', $banner_id, $adgroup_id), $user_banner);
            }
            elsif ($ex_banner->status_archived eq 'Yes') {
                # TODO: Подумать на предупреждением вместо ошибки?
                $self->_add_error(iget('Ошибка: объявление №%d находится в архиве и не может быть изменено', $banner_id), $user_banner);
            }

            if (!@{$self->errors} && $user_banner->{ad_type} && (
                ($ex_banner->banner_type =~ /text|mobile_content/ && $user_banner->{ad_type} ne 'text')
             || ($ex_banner->banner_type eq 'image_ad'            && $user_banner->{ad_type} ne 'image_ad') )
            ) {
                $self->_add_error(iget("Неверные входные данные"), $user_banner);
            }
        }

        if ($self->is_text_campaign || $self->is_mobile_content_campaign || $self->is_cpm_banner_campaign || $self->is_cpm_deals_campaign) {
            $self->_check_existing_keywords($user_adgroup);
            $self->_check_existing_retargetings($user_adgroup);
        } elsif ($self->is_mcbanner_campaign) {
            $self->_check_existing_keywords($user_adgroup);
        } elsif ($self->is_dynamic_campaign) {
            my $ex_dyn_cond_by_id = {map { $_->id => $_ } @{$self->_ex_dyn_conds_by_gid->{$adgroup_id}}};

            for my $user_dyn_cond (@{$user_adgroup->{dynamic_conditions} // []}) {
                my $dyn_id = $user_dyn_cond->{dyn_id};
                next unless $dyn_id;

                my $ex_dyn_cond = $ex_dyn_cond_by_id->{$dyn_id};

                # Условие нацеливания с идентификатором (> 0) не может находится в новой группе
                if (!$adgroup_id) {
                    $self->_add_error(iget('Ошибка: условие нацеливания №%d не может находится в новой группе', $dyn_id), $user_dyn_cond);
                }
                elsif (!$ex_dyn_cond) {
                    $self->_add_error(iget('Ошибка: условие нацеливания №%d не найдено в группе №%d', $dyn_id, $adgroup_id), $user_dyn_cond);
                }
            }
        } elsif ($self->is_performance_campaign) {
            my $ex_perf_filter_by_id = {map { $_->id => $_ } @{$self->_ex_perf_filters_by_gid->{$adgroup_id}}};

            for my $user_perf_filter (@{$user_adgroup->{performance_filters} // []}) {
                my $perf_filter_id = $user_perf_filter->{perf_filter_id};
                next unless $perf_filter_id;

                my $ex_perf_filter = $ex_perf_filter_by_id->{$perf_filter_id};

                # Перфоманс фильтр с идентификатором (> 0) не может находится в новой группе
                if (!$adgroup_id) {
                    $self->_add_error(iget('Ошибка: фильтр №%d не может находится в новой группе', $perf_filter_id), $user_perf_filter);
                }
                elsif (!$ex_perf_filter) {
                    $self->_add_error(iget('Ошибка: фильтр №%d не найден в группе №%d', $perf_filter_id, $adgroup_id), $user_perf_filter);
                }
            }
        }
    }
    return $self if @{$self->errors};

    #
    # Подготовка моделей
    #
    for my $user_adgroup (@$user_adgroups) {
        my $adgroup = $self->_prepare_adgroup_from_user_data($user_adgroup);

        my %bids_to_delete = map { $_->{banner_id} => 1 } grep { $_->{_delete} } @{$user_adgroup->{banners} // []};
        my $banners = $self->_prepare_banners_from_user_data($adgroup, $user_adgroup->{banners});

        my $data_item_to_apply = {
            adgroup => $adgroup,
            banners => [grep { !$bids_to_delete{$_->id} } @$banners],
            banners_to_delete => [grep { $bids_to_delete{$_->id} } @$banners],
        };

        # Условия показа - ключевые фразы
        if (any { $adgroup->adgroup_type eq $_ } qw/base mobile_content mcbanner cpm_banner/) {
            my $user_keywords = $user_adgroup->{keywords} // [];
            my $keywords = $data_item_to_apply->{keywords} = [];

            my $keywords_to_save = $self->_prepare_keywords_from_user_data($adgroup, $user_keywords);
            push @$keywords, @$keywords_to_save;

            # Для применения изменений по ключевым фразам -- необходимо иметь их полный набор на группу
            if (!$self->replace_show_conditions) {
                my $keyword_to_update_by_id = {map { $_->id => 1 } grep { $_->id } @$keywords_to_save};
                my $keyword_to_delete_by_id = {map { $_->{id} => 1 } grep { $_->{id} && $_->{_delete} } @$user_keywords};

                # Дополним старыми ключевыми фразами (пропустим те, которые уже есть в списках на обновление/удаление)
                push @$keywords, grep {
                    !$keyword_to_update_by_id->{$_->id} && !$keyword_to_delete_by_id->{$_->id}
                } @{$self->_ex_keywords_by_gid->{$adgroup->id} // []};

                # На добавленных выше ключевых фразах должна быть группа
                $_->adgroup($adgroup) for grep { !$_->has_adgroup } @$keywords;
            }

            $adgroup->keywords_count(scalar(@$keywords));

            if (@$keywords && $self->is_cpm_deals_campaign) {
                $adgroup->has_private_criterion(1); # фразы относим к приватным данным
            }

            if (@$keywords && $adgroup->adgroup_type eq 'cpm_banner') {
                $adgroup->criterion_type('keyword');
            }
        }

        # Условия показа - БТ, ретаргетинг, интересы
        if (any { $adgroup->adgroup_type eq $_ } qw/base mobile_content cpm_banner cpm_video/) {
            # Ретаргетинг

            my $user_retargetings = $user_adgroup->{retargetings} // [];
            my $retargetings = $data_item_to_apply->{retargetings} = [];

            my $retargetings_to_save = $self->_prepare_retargetings_from_user_data($adgroup, $user_retargetings);
            if ($self->is_cpm_deals_campaign && $user_retargetings && @$user_retargetings) {
                $adgroup->has_private_criterion($self->_get_cpm_deals_criteria_private_status($user_retargetings));
            }

            push @$retargetings, @$retargetings_to_save;

            # Для применения изменений по ретаргетингу -- необходимо иметь их полный набор на группу
            if (!$self->replace_show_conditions) {
                my $retargeting_to_update_by_id = {map { $_->id => 1 } grep { $_->id } @$retargetings_to_save};
                my $retargeting_to_delete_by_id = {map { $_->{ret_id} => 1} grep { $_->{ret_id} && $_->{_delete} } @$user_retargetings};

                # Дополним старым ретаргетингом (пропустим тот, который уже есть в списках на обновление/удаление)
                push @$retargetings, grep {
                    !$retargeting_to_update_by_id->{$_->id} && !$retargeting_to_delete_by_id->{$_->id}
                } @{$self->_ex_retargetings_by_gid->{$adgroup->id} // []};

                # На добавленном выше ретаргетинге должна быть группа
                $_->adgroup($adgroup) for grep { !$_->has_adgroup } @$retargetings;
            }

            $adgroup->retargetings_count(scalar(@$retargetings));

            if (@$retargetings && $adgroup->adgroup_type eq 'cpm_banner') {
                $adgroup->criterion_type('user_profile');
            }
        }

        if (any { $adgroup->adgroup_type eq $_ } qw/base mobile_content/) {
            # Беcфразный таргетинг
            my $user_relevance_matches = $user_adgroup->{relevance_match} // [];
            my $relevance_matches = $data_item_to_apply->{relevance_matches} = [];
            my $relevance_matches_to_save = $self->_prepare_relevance_match_from_user_data($adgroup, $user_relevance_matches);
            push @$relevance_matches, @$relevance_matches_to_save;
            if (!$self->replace_show_conditions) {
                my $relevance_matches_to_update_by_id = {map { $_->id => 1 } grep { $_->id } @$relevance_matches_to_save};
                my $relevance_matches_to_delete_by_id = {map { $_->{bid_id} => 1} grep { $_->{bid_id} && $_->{_delete} } @$user_relevance_matches};

                # Дополним старыми условиями беcфразного таргетинга (пропустим те, которые уже есть в списках на обновление/удаление)
                push @$relevance_matches, grep {
                        !$relevance_matches_to_update_by_id->{$_->id} && !$relevance_matches_to_delete_by_id->{$_->id}
                } @{$self->_ex_relevance_matches_by_gid->{$adgroup->id} // []};

                # На добавленных выше условий беcфразного таргетинга должна быть группа
                $_->adgroup($adgroup) for grep { !$_->has_adgroup } @$relevance_matches;
            }

            # Интересы

            my $user_target_interests = $user_adgroup->{target_interests} // [];
            my $target_interests = $data_item_to_apply->{target_interests} = [];
            push @$target_interests, @{ $self->_prepare_target_interests_from_user_data($adgroup, $user_target_interests) };


            $adgroup->relevance_matches_count(scalar(@$relevance_matches));
            $adgroup->active_target_interests_count(scalar(grep { !$_->is_suspended } @$target_interests));
        }

        # Условия нацеливания
        if ($adgroup->adgroup_type eq 'dynamic') {
            my $user_dynamic_conditions = $user_adgroup->{dynamic_conditions} // [];
            my $dynamic_conditions = $data_item_to_apply->{dynamic_conditions} = [];

            my $dyn_conds_to_save = $self->_prepare_dyn_conds_from_user_data($adgroup, $user_dynamic_conditions);
            push @$dynamic_conditions, @$dyn_conds_to_save;

            # Для применения изменений по условиям нацеливания -- необходимо иметь их полный набор на группу
            if (!$self->replace_show_conditions) {
                my $dyn_cond_to_update_by_id = {map { $_->id => 1 } grep { $_->id } @$dyn_conds_to_save};
                my $dyn_cond_to_delete_by_id = {map { $_->{dyn_id} => 1 } grep { $_->{dyn_id} && $_->{_delete} } @$user_dynamic_conditions};

                # Дополним старыми условиями нацеливания (пропустим те, которые уже есть в списках на обновление/удаление)
                push @$dynamic_conditions, grep {
                    !$dyn_cond_to_update_by_id->{$_->id} && !$dyn_cond_to_delete_by_id->{$_->id}
                } @{$self->_ex_dyn_conds_by_gid->{$adgroup->id} // []};

                # На добавленных ваше условиях нацеливания должна быть группа
                $_->adgroup($adgroup) for grep { !$_->has_adgroup } @$dynamic_conditions;
            }

            $adgroup->dyn_conds_count(scalar(@$dynamic_conditions));
        }

        # Перфоманс фильтры
        if ($adgroup->adgroup_type eq 'performance') {
            my $user_perf_filters = $user_adgroup->{performance_filters} // [];
            my $perf_filters = $data_item_to_apply->{performance_filters} = [];

            my $perf_filters_to_save = $self->_prepare_perf_filters_from_user_data($adgroup, $user_perf_filters);
            push @$perf_filters, @$perf_filters_to_save;

            # Для применения изменений по фильтрам -- необходимо иметь их полный набор на группу
            if (!$self->replace_show_conditions) {
                my $perf_filter_to_update_by_id = {map { $_->id => 1 } grep { $_->id } @$perf_filters_to_save};
                my $perf_filter_to_delete_by_id = {
                    map { $_->{perf_filter_id} => 1 } grep { $_->{perf_filter_id} && $_->{_delete} } @$user_perf_filters
                };

                # Дополним старыми фильтрами (пропустим те, которые уже есть в списках на обновление/удаление)
                push @$perf_filters, grep {
                    !$perf_filter_to_update_by_id->{$_->id} && !$perf_filter_to_delete_by_id->{$_->id}
                } @{$self->_ex_perf_filters_by_gid->{$adgroup->id} // []};

                # На добавленных ваше фильтрах должна быть группа
                $_->adgroup($adgroup) for grep { !$_->has_adgroup } @$perf_filters;
            }

            $adgroup->perf_filters_count(scalar(@$perf_filters));

            foreach my $field_name (qw/field_to_use_as_name field_to_use_as_body/) {
                # если это явное редактирование группы, DIRECT-83200
                if (defined($user_adgroup->{$field_name})) {
                    if ($user_adgroup->{$field_name} eq "") {
                        $adgroup->$field_name(undef);
                    } else {
                        $adgroup->$field_name($user_adgroup->{$field_name});
                    }
                }
            }
        }

        push @{$self->_data_to_apply}, $data_item_to_apply;
    }

    $self->_process_bs_data();

    return $self;
}

sub _get_cpm_deals_criteria_private_status {
    my ($self, $criteria) = @_;

    my $has_private_criterion = 0;
    foreach my $criterion (@$criteria) {
        my @goal_ids = map { map { $_->{id} // () } @{$_->{goals} // []} } @{$criterion->{groups} // []};
        if (any { !exists $Direct::Model::RetargetingCondition::Goal::Constants::PUBLIC_CRYPTA_GOALS->{$_} } @goal_ids) {
            $has_private_criterion = 1;
            last;
        }
    }

    return $has_private_criterion;
}

sub _check_existing_keywords {
    my ($self, $user_adgroup) = @_;

    my $adgroup_id = $user_adgroup->{adgroup_id} || 0;
    my $ex_keyword_by_id = {map { $_->id => $_ } @{$self->_ex_keywords_by_gid->{$adgroup_id}}};

    for my $user_keyword (@{$user_adgroup->{keywords} // []}) {
        my $kw_id = $user_keyword->{id};
        next if !$kw_id;

        my $ex_keyword = $ex_keyword_by_id->{$kw_id};

        # Ключевая фраза с идентификатором (> 0) не может находится в новой группе
        if (!$adgroup_id) {
            $self->_add_error(iget('Ошибка: ключевая фраза №%d не может находится в новой группе', $kw_id), $user_keyword);
        }
        elsif (!$ex_keyword) {
            $self->_add_error(iget('Ошибка: ключевая фраза №%d не найдена в группе №%d', $kw_id, $adgroup_id), $user_keyword);
        }
    }
}

sub _check_existing_retargetings {
    my ($self, $user_adgroup) = @_;

    my $adgroup_id = $user_adgroup->{adgroup_id} || 0;
    my $ex_retargeting_by_id = {map { $_->id => $_ } @{$self->_ex_retargetings_by_gid->{$adgroup_id}}};

    for my $user_ret (@{$user_adgroup->{retargetings} // []}) {
        my $ret_cond_id = $user_ret->{ret_cond_id} || 0;

        if ((!defined $user_ret->{type} || $user_ret->{type} ne 'interests') && !exists $self->_ex_ret_cond_by_id->{$ret_cond_id}) {
            $self->_add_error(iget('Ошибка: условие подбора аудитории №%d не найдено', $ret_cond_id), $user_ret);
        }

        # для новой cpm кампании создаем новое условие ретаргетинга, не даем сохранять с существующим ret_cond_id
        if (($self->is_cpm_banner_campaign || $self->is_cpm_deals_campaign) && !$adgroup_id) {
            delete $user_ret->{ret_id};
            delete $user_ret->{ret_cond_id};
        }

        my $ret_id = $user_ret->{ret_id};
        next if !$ret_id;

        my $ex_retargeting = $ex_retargeting_by_id->{$ret_id};

        # Условие ретаргетинга с идентификатором (> 0) не может находится в новой группе
        if (!$adgroup_id) {
            $self->_add_error(iget('Ошибка: нельзя перенести условие подбора аудитории №%d в новую группу объявлений', $ret_id), $user_ret);
        }
        elsif (!$ex_retargeting) {
            $self->_add_error(iget('Ошибка: условие подбора аудитории №%d не найдено в группе объявлений №%d', $ret_id, $adgroup_id), $user_ret);
        }
    }
}

sub _prepare_adgroup_from_user_data {
    my ($self, $user_adgroup) = @_;

    my $adgroup;
    my $is_new_adgroup = 1;

    #
    # Создание объекта Direct::Model::AdGroup нужного подтипа
    #
    if (my $adgroup_id = $user_adgroup->{adgroup_id}) {
        $adgroup = $self->_ex_adgroup_by_id->{$adgroup_id}->clone;
        $adgroup->old($self->_ex_adgroup_by_id->{$adgroup_id});
        $is_new_adgroup = 0;
    } elsif ($self->is_text_campaign) {
        $adgroup = Direct::Model::AdGroupText->new(
            id => 0, client_id => $self->client_id, campaign_id => $self->campaign_id,
            has_show_conditions => 0, banners_count => 0,
            keywords_count => 0, active_keywords_count => 0,
            relevance_matches_count => 0, active_relevance_matches_count => 0,
            retargetings_count => 0, active_retargetings_count => 0, active_target_interests_count => 0,
            is_bs_rarely_loaded => 0
        );
    } elsif ($self->is_dynamic_campaign) {
        $adgroup = Direct::Model::AdGroupDynamic->new(
            id => 0, client_id => $self->client_id, campaign_id => $self->campaign_id,
            has_show_conditions => 0, banners_count => 0, dyn_conds_count => 0,
            is_bs_rarely_loaded => 0
        );
    } elsif ($self->is_mobile_content_campaign) {
        $adgroup = Direct::Model::AdGroupMobileContent->new(
            id => 0, client_id => $self->client_id, campaign_id => $self->campaign_id,
            has_show_conditions => 0, banners_count => 0,
            keywords_count => 0, active_keywords_count => 0,
            relevance_matches_count => 0, active_relevance_matches_count => 0,
            retargetings_count => 0, active_retargetings_count => 0,
            active_target_interests_count => 0,
            is_bs_rarely_loaded => 0
        );
    } elsif ($self->is_performance_campaign) {
        $adgroup = Direct::Model::AdGroupPerformance->new(
            id => 0, client_id => $self->client_id, campaign_id => $self->campaign_id,
            has_show_conditions => 0, banners_count => 0, perf_filters_count => 0,
            is_bs_rarely_loaded => 0
        );
    } elsif ($self->is_mcbanner_campaign) {
        $adgroup = Direct::Model::AdGroupMcbanner->new(
            id => 0, client_id => $self->client_id, campaign_id => $self->campaign_id,
            has_show_conditions => 0, banners_count => 0,
            keywords_count => 0, active_keywords_count => 0,
            is_bs_rarely_loaded => 0,
        );
    } elsif ($self->is_cpm_banner_campaign) {
        if ($user_adgroup->{adgroup_type} eq 'cpm_banner') {
            $adgroup = Direct::Model::AdGroupCpmBanner->new(
                id => 0, client_id => $self->client_id, campaign_id => $self->campaign_id,
                has_show_conditions => 0, banners_count => 0,
                keywords_count => 0, active_keywords_count => 0,
                retargetings_count => 0, active_retargetings_count => 0,
                is_bs_rarely_loaded => 0,
            );
        } elsif ($user_adgroup->{adgroup_type} eq 'cpm_video') {
            $adgroup = Direct::Model::AdGroupCpmVideo->new(
                id => 0, client_id => $self->client_id, campaign_id => $self->campaign_id,
                has_show_conditions => 0, banners_count => 0,
                keywords_count => 0, active_keywords_count => 0,
                retargetings_count => 0, active_retargetings_count => 0,
                is_bs_rarely_loaded => 0,
            );
        } else {
            die "adgroup_type required";
        }
    } elsif ($self->is_cpm_deals_campaign) {
        $adgroup = Direct::Model::AdGroupCpmBanner->new(
            id => 0, client_id => $self->client_id, campaign_id => $self->campaign_id,
            has_show_conditions => 0, banners_count => 0,
            keywords_count => 0, active_keywords_count => 0,
            retargetings_count => 0, active_retargetings_count => 0,
            is_bs_rarely_loaded => 0,
        );
    }

    #
    # Применение пользовательских данных
    #

    # Если хотим сохранить баннеры как черновик, то и группу сохраняем тоже
    # Кажется, это не всегда правильно, но пока так
    # также например, из XLS надо только некоторые группы отправить на модерацию, избранные, знания о них находится в user_adgroup
    $adgroup->status_moderate('New') if $self->save_as_draft || $user_adgroup->{save_as_draft};

    if (exists $user_adgroup->{adgroup_name} || $is_new_adgroup) {
        $adgroup->adgroup_name(smartstrip2($user_adgroup->{adgroup_name}));
    }

    if (exists $user_adgroup->{minus_words} || $is_new_adgroup) {
        $adgroup->minus_words($user_adgroup->{minus_words} // []);
    }

    # Гео
    if (exists $user_adgroup->{geo} || $is_new_adgroup) {
        my $user_geo = $user_adgroup->{geo} // '';
        my $geo = $user_adgroup->{geo_is_modified_before_save} ? $user_geo
            : GeoTools::modify_translocal_region_before_save($user_geo, {ClientID => $adgroup->client_id});
        $geo = GeoTools::refine_geoid($geo, \my $geoflag, {ClientID => $adgroup->client_id});
        $adgroup->geo($user_geo gt '' ? $geo : '');
        $adgroup->geoflag($geoflag);
    } else {
        # Все равно нужно посчитать geoflag
        GeoTools::refine_geoid($adgroup->geo, \my $geoflag, {ClientID => $adgroup->client_id});
        $adgroup->geoflag($geoflag);
    }

    # Коэффициенты
    if (exists $user_adgroup->{hierarchical_multipliers} || $is_new_adgroup) {
        $adgroup->hierarchical_multipliers($user_adgroup->{hierarchical_multipliers} // {});
    }

    # Теги (меняем, если пользователь включил работу с тегами)
    if (exists $user_adgroup->{tags} && $self->user->tags_allowed eq 'Yes') {
        my $tag_id2name = $self->_campaign_tag_id2name;
        my $tag_name2id = {map { (lc($tag_id2name->{$_}) => $_) } keys %$tag_id2name};

        if (ref($user_adgroup->{tags}) eq 'HASH') {
            # Передали идентификаторы тегов, которые нужно привязать
            $adgroup->tags([
                map { Direct::Model::Tag->new(id => $_, campaign_id => $adgroup->campaign_id, tag_name => $tag_id2name->{$_}) }
                grep { $user_adgroup->{tags}->{$_} && exists $tag_id2name->{$_} } keys %{$user_adgroup->{tags}}
            ]);
        } elsif (ref($user_adgroup->{tags}) eq 'ARRAY') {
            # Передали список тегов в виде строк
            $adgroup->tags([
                map {
                    Direct::Model::Tag->new(id => $tag_name2id->{lc $_} // 0, campaign_id => $adgroup->campaign_id, tag_name => $_)
                } grep { ($_ // '') =~ /\S/ } map { smartstrip2($_) } @{$user_adgroup->{tags}}
            ]);
        }
    } else {
        $adgroup->tags([]) if $is_new_adgroup;
    }

    # Параметры для подстановки в URL ссылки
    if (exists $user_adgroup->{href_params} || $is_new_adgroup) {
        my $href_params = smartstrip2($user_adgroup->{href_params}) // '';
        # Уберём начальные ?&
        $href_params =~ s/^(?:&|\?)//;
        $adgroup->href_params(length $href_params ? $href_params : undef);
    }

    # Обработка подтипа: Динамическая группа
    if ($adgroup->adgroup_type eq 'dynamic') {
        if (exists $user_adgroup->{main_domain} || $is_new_adgroup) {
            $adgroup->main_domain($user_adgroup->{main_domain});
        }
    }

    # Обработка подтипа: РМП группа
    if ($adgroup->adgroup_type eq 'mobile_content') {
        if (exists $user_adgroup->{store_content_href} || $is_new_adgroup) {
            $adgroup->store_content_href(smartstrip2($user_adgroup->{store_content_href}));
        }
        if (exists $user_adgroup->{device_type_targeting} || $is_new_adgroup) {
            $adgroup->device_type_targeting($user_adgroup->{device_type_targeting});
        }
        if (exists $user_adgroup->{network_targeting} || $is_new_adgroup) {
            $adgroup->network_targeting($user_adgroup->{network_targeting});
        }
        if (exists $user_adgroup->{min_os_version} || $is_new_adgroup) {
            $adgroup->min_os_version(smartstrip2($user_adgroup->{min_os_version}));
        }
    }

    # Фид (Перфоманс/Динамическая группы)
    if (any { $adgroup->adgroup_type eq $_ } qw/performance dynamic/) {
        if (exists $user_adgroup->{feed_id} || $is_new_adgroup) {
            $adgroup->feed_id($user_adgroup->{feed_id});
        }
    }

    return $adgroup;
}

sub _get_all_turbolanding_ids {
    my ($user_banners) = @_;

    my $t_ids;
    foreach my $user_banner (@$user_banners) {
        if (exists $user_banner->{turbolanding}) {
            $t_ids->{$user_banner->{turbolanding}->{id}} //= 1;
        }
        if (exists $user_banner->{sitelinks}) {
            foreach my $sitelink (@{$user_banner->{sitelinks}}){
                if (exists $sitelink->{turbolanding}) {
                    $t_ids->{$sitelink->{turbolanding}->{id}} //= 1;
                }
                elsif(exists $sitelink->{tl_id}){
                    $t_ids->{$sitelink->{tl_id}} //= 1;
                }
            }
        }
    }
    
    return [ grep {$_ > 0} keys %$t_ids];
}

sub _prepare_banners_from_user_data {
    my ($self, $adgroup, $user_banners) = @_;

    return [] unless @{$user_banners // []};

    my @banners;
    my $ex_banner_by_id = {map { $_->id => $_ } @{$self->_ex_banners_by_gid->{$adgroup->id} // []}};
    
    my $turbolanding_ids = _get_all_turbolanding_ids($user_banners);
    $self->_ex_turbolandings( {
            map {$_->id => $_}
            @{Direct::TurboLandings->sync_by_client_id($adgroup->client_id, $turbolanding_ids)}
        }
    ) if @$turbolanding_ids;

    for my $user_banner (@$user_banners) {

        my $banner;
        my $is_new_banner = 1;
        my $ad_type = $user_banner->{ad_type} // '';

        #
        # Создание объекта Direct::Model::Banner нужного подтипа
        #
        if (my $banner_id = $user_banner->{banner_id}) {
            $banner = $ex_banner_by_id->{$banner_id}->clone;
            $banner->old($ex_banner_by_id->{$banner_id});
            $is_new_banner = 0;
        } elsif (($user_banner->{ad_type} // '') eq 'image_ad') {
            $banner = Direct::Model::BannerImageAd->new(
                id => 0, client_id => $adgroup->client_id, campaign_id => $adgroup->campaign_id, adgroup_id => $adgroup->id,
            );
        } elsif ($adgroup->adgroup_type eq 'base' && $ad_type ne 'cpc_video') {
            $banner = Direct::Model::BannerText->new(
                id => 0, client_id => $adgroup->client_id, campaign_id => $adgroup->campaign_id, adgroup_id => $adgroup->id,
            );
        } elsif ($adgroup->adgroup_type eq 'dynamic') {
            $banner = Direct::Model::BannerDynamic->new(
                id => 0, client_id => $adgroup->client_id, campaign_id => $adgroup->campaign_id, adgroup_id => $adgroup->id,
            );
        } elsif ($adgroup->adgroup_type eq 'mobile_content' && $ad_type ne 'cpc_video') {
            $banner = Direct::Model::BannerMobileContent->new(
                id => 0, client_id => $adgroup->client_id, campaign_id => $adgroup->campaign_id, adgroup_id => $adgroup->id,
            );
        } elsif ($adgroup->adgroup_type eq 'performance') {
            $banner = Direct::Model::BannerPerformance->new(
                id => 0, client_id => $adgroup->client_id, campaign_id => $adgroup->campaign_id, adgroup_id => $adgroup->id,
                creative => $self->_ex_creative_by_id->{$user_banner->{creative_id}},
            );
        } elsif (($user_banner->{ad_type} // '') eq 'mcbanner') {
            $banner = Direct::Model::BannerMcbanner->new(
                id => 0, client_id => $adgroup->client_id, campaign_id => $adgroup->campaign_id, adgroup_id => $adgroup->id,
            );
        } elsif (($user_banner->{ad_type} // '') eq 'cpm_banner') {
            $banner = Direct::Model::BannerCpmBanner->new(
                id => 0, client_id => $adgroup->client_id, campaign_id => $adgroup->campaign_id, adgroup_id => $adgroup->id,
            );
        } elsif (($user_banner->{ad_type} // '') eq 'cpc_video') {
            $banner = Direct::Model::BannerCpcVideo->new(
                id => 0, client_id => $adgroup->client_id, campaign_id => $adgroup->campaign_id, adgroup_id => $adgroup->id,
            );
        }

        $banner->adgroup($adgroup);

        if ($user_banner->{_delete}) {
            # Если нужно удалить баннер, то дальше ничего не делаем
            push @banners, $banner;
            next;
        }

        if ($ad_type eq 'image_ad' || $ad_type eq 'cpm_banner' || $ad_type eq 'cpc_video') {
            if ($user_banner->{creative}) { # canvas-creative
                my $creative_id = $user_banner->{creative}->{creative_id};
                if (!$banner->has_creative) {
                    if ($ad_type eq 'image_ad' && $banner->has_image_ad) {
                        $self->_add_error(iget('Объявление M-%s: невозможно изменить тип изображения', $banner->id));
                    } elsif (!defined $self->_ex_creative_canvas_by_id->{$creative_id}) {
                        $self->_add_error(iget('Нет доступа к креативу %s', $creative_id));
                    }
                    else {
                        my $canvas_creative = Direct::Model::BannerCreative->new(
                            campaign_id => $adgroup->campaign_id,
                            adgroup_id => $adgroup->id,
                            banner_id => $banner->id,
                            creative_id => $creative_id,
                            creative => $self->_ex_creative_canvas_by_id->{$creative_id},
                        );
                        $banner->creative($canvas_creative);
                    }
                } else {
                    if (!defined $self->_ex_creative_canvas_by_id->{$creative_id}) {
                        $self->_add_error(iget('Нет доступа к креативу %s', $creative_id));
                    } else {
                        $banner->creative->creative_id($creative_id);
                        $banner->creative->creative($self->_ex_creative_canvas_by_id->{$creative_id});
                    }
                }
            } else { # image
                my $hash = '' . ($user_banner->{image_ad}->{hash} // '');
                if (!$banner->has_image_ad) { # is create
                    if ($banner->has_creative) {
                        $self->_add_error(iget('Объявление M-%s: невозможно изменить тип изображения', $banner->id));
                    } else {
                        my $image_ad = Direct::Model::Image->new(
                            campaign_id => $adgroup->campaign_id,
                            adgroup_id => $adgroup->id,
                            banner_id => $banner->id,
                            hash => $hash,
                        );
                        $banner->image_ad($image_ad);
                    }
                } elsif($hash gt '') {
                    $banner->image_ad->hash($user_banner->{image_ad}->{hash});
                    $banner->image_ad->format($self->_ex_format_by_hash->{$hash});
                }
            }
        }
        if ($ad_type eq 'mcbanner') {
            my $hash = '' . ($user_banner->{image_ad}->{hash} // '');
            if (!$banner->has_image_ad) { # is create
                if ($hash gt '') {
                    # TODO DIRECT-67003 наугад пробуем не создавать пустую модель если не из чего. в image_ad не так, и валидация не умеет проверять что картинки нет, там это подперто generic-ошибками по возможным значениям пришедших полей.
                    # пробуем сделать правильно и дать возможность через серверную валидацию понять, в каком из пачки баннеров - нет картинки
                    my $image_ad = Direct::Model::Image->new(
                        campaign_id => $adgroup->campaign_id,
                        adgroup_id => $adgroup->id,
                        banner_id => $banner->id,
                        hash => $hash,
                    );
                    $banner->image_ad($image_ad);
                    # TODO DIRECT-67003 подозрительно. надо ли тут заполнять/есть ли всегда чем, чтобы провалидировать?
                    $banner->image_ad->format($self->_ex_format_by_hash->{$hash});
                }
            } elsif($hash gt '') {
                $banner->image_ad->hash($user_banner->{image_ad}->{hash});
                $banner->image_ad->format($self->_ex_format_by_hash->{$hash});
            }
        }

        #
        # Применение пользовательских данных
        #

        # Статус модерации
        if ($self->save_as_draft || $user_banner->{save_as_draft}) {
            $banner->status_moderate('New');
        } else {
            # Отправляем на модерацию новые баннеры, или, если предыдущий был черновиком.
            # Иначе - необходимость модерации будет решать уже метод create/update
            $banner->status_moderate('Ready') if $is_new_banner || $banner->old->status_moderate eq 'New';
        }

        # Постмодерация
        $banner->do_post_moderate(1) if $self->post_moderate;

        # Нужно ли сбросить язык на баннере
        my $should_clear_banner_language = 0;

        # Основные поля баннера
        if ($banner->is_title_supported && (exists $user_banner->{title} || $is_new_banner)) {
            $banner->title(smartstrip2($user_banner->{title}, dont_replace_angle_quotes => 1));

            $should_clear_banner_language = 1;
        }
        if ($banner->is_title_extension_supported && (exists $user_banner->{title_extension} || $is_new_banner)) {
            $banner->title_extension(smartstrip2($user_banner->{title_extension}, dont_replace_angle_quotes => 1) || undef);

            $should_clear_banner_language = 1;
        }
        if ($banner->is_body_supported && (exists $user_banner->{body} || $is_new_banner)) {
            $banner->body(smartstrip2($user_banner->{body}, dont_replace_angle_quotes => 1));

            $should_clear_banner_language = 1;
        }

        if ($should_clear_banner_language) {
            $banner->language($Direct::Model::Banner::Constants::BANNER_NO_LANGUAGE);
        }

        if ($banner->is_href_supported) {
            if (exists $user_banner->{href} || $is_new_banner) {
                my $href = URLDomain::clear_banner_href(smartstrip2($user_banner->{href}), $user_banner->{url_protocol});
                $banner->href(defined $href && length $href > 0 ? $href : undef);

                # Принудительно обновим domain
                $banner->domain(smartstrip2($user_banner->{domain}) || undef);
            }

            $banner->domain(smartstrip2($user_banner->{domain}) || undef) if exists $user_banner->{domain};
        }

        $banner->geoflag(!!$adgroup->geoflag);

        #
        # Визитка
        #
        if ($banner->is_vcard_supported) {
            if ($user_banner->{vcard}) {
                $banner->vcard($self->_prepare_vcard_from_user_data($banner, $user_banner->{vcard}));
                $banner->vcard_id($banner->vcard->id || undef);
            } elsif (exists $user_banner->{vcard} || $is_new_banner) {
                $banner->vcard_id(undef);
                $banner->clear_vcard();
            }
        }

        #
        # Картинка
        #
        if ($banner->is_image_supported) {
            if ($user_banner->{image}) {
                my $hash = $user_banner->{image};
                $banner->image_hash($hash);
                $banner->image(Direct::Model::BannerImage->new(id => 0, hash => $hash, name => $user_banner->{image_name}));
                $banner->image->format($self->_ex_format_by_hash->{$user_banner->{image}});
            } else {
                if ($user_banner->{image_id} && $banner->has_image && $user_banner->{image_id} == $banner->image->id) {
                    # Если передан идентификатор картинки и он совпадает с тем, что есть сейчас - то ок, сохраним
                } elsif (exists $user_banner->{image} || $is_new_banner) {
                    $banner->image_hash(undef);
                    $banner->clear_image();
                }
            }
        }

        if (($banner->does('Direct::Model::BannerImage::Role::Url')) && defined $user_banner->{image_url} ) {
            $banner->url($user_banner->{image_url});
        }

        #
        # Сайтлинки
        #
        if ($banner->is_sitelinks_set_supported) {
            if ($user_banner->{sitelinks}) {
                if (defined (my $sitelinks_set = $self->_prepare_sitelinks_set_from_user_data($banner, $user_banner->{sitelinks}))) {
                    $banner->sitelinks_set_id($sitelinks_set->id || undef);
                    $banner->sitelinks_set($sitelinks_set);
                } else {
                    $banner->sitelinks_set_id(undef);
                    $banner->clear_sitelinks_set();
                }
            } elsif (exists $user_banner->{sitelinks} || $is_new_banner) {
                $banner->sitelinks_set_id(undef);
                $banner->clear_sitelinks_set();
            }
        }

        #
        #Турблендинг
        #
        if ($banner->is_turbolanding_supported) {
            $banner->turbolanding_href_params($user_banner->{turbolanding_href_params})
                if (exists $user_banner->{turbolanding_href_params});
                
            if ($user_banner->{turbolanding}) {
                my $turbolanding = $self->_prepare_turbolanding_from_user_data($banner, $user_banner->{turbolanding});
                $banner->tl_id($turbolanding->{id});
                $banner->turbolanding($turbolanding);
            }
            elsif ($banner->has_turbolanding) {
                $banner->do_delete_turbolanding(1);
                $banner->do_delete_turbolanding_from_moderation(1);
                $banner->status_bs_synced('No');
            }
        }

        #
        # Уточнения
        #
        if ($banner->is_callouts_supported()) {
            my $items_callouts = [];
            if (ref($user_banner->{callouts}) eq 'ARRAY') {
                for my $callout_text (map {$_->{callout_text}} @{$user_banner->{callouts}}) {
                    my $one_callout = Direct::Model::AdditionsItemCallout->new(
                        callout_text => $callout_text,
                        client_id    => $self->client_id,
                    );
                    push @$items_callouts, $one_callout;
                }
            }
            $banner->additions_callouts($items_callouts);
        }

        if ($banner->is_permalink_supported) {
            if ($user_banner->{permalink}) {
                $banner->permalink($user_banner->{permalink});
            } else {
                $banner->clear_permalink();
            }
        }

        # пиксели аудита/аудитории
        if ($banner->is_pixels_supported) {
            my $pixels = [];
            if (ref($user_banner->{pixels}) eq 'ARRAY') {
                foreach my $pixel_data (@{$user_banner->{pixels}}) {
                    my $pixel = Direct::Model::Pixel->new(
                        url => $pixel_data->{url},
                        exists $pixel_data->{kind} ? (kind => $pixel_data->{kind}) : (),
                    );
                    push @$pixels, $pixel;
                }
            }
            $banner->pixels($pixels);
        }

        # Отображаемый урл
        if ($banner->is_display_href_supported) {
            if (exists $user_banner->{display_href} || $is_new_banner) {
                $banner->display_href($user_banner->{display_href} || undef);
            }
        }

        if ($banner->is_disable_display_href_supported) {
            if (exists $user_banner->{disable_display_href} || $is_new_banner) {
                $banner->disable_display_href($user_banner->{disable_display_href});
            }
        }

        if ($banner->banner_type eq 'text') {
            # Поле можно задать только при создании нового баннера
            $banner->is_mobile(!!$user_banner->{is_mobile}) if $is_new_banner;
        }

        # Видео дополнение
        if ($banner->banner_type eq 'text' || $banner->banner_type eq 'mobile_content') {
            if (!$user_banner->{video_resources}->{id}) {
                $banner->clear_creative();

            } elsif (($user_banner->{video_resources}->{resource_type}//'') eq 'creative') {
                my $cr_id = $user_banner->{video_resources}->{id};
                if ($cr_id == 0) {
                    # удаление дополнения
                    $banner->clear_creative();
                }
                else {
                    my $creative;
                    if ($banner->has_id && $banner->id) {
                        # у существующего баннера пытаемся найти старое дополнение
                        $creative = $self->_ex_banner_creatives_by_id->{$banner->id};
                    }
                    if (!$creative) {
                        # запись в perf_creatives уже есть, но в banners_performance еще нет
                        $creative = Direct::Model::BannerCreative->new(
                            id => 0, campaign_id => $self->campaign_id,
                            adgroup_id => $banner->adgroup_id, banner_id => $banner->id,
                            creative_id => $cr_id,
                        );
                    }
                    $banner->creative($creative);
                    my $video = $self->_ex_video_resource_by_id->{$cr_id};
                    unless ($video) {
                        if ($self->_gen_video_resource_by_id->{$cr_id}) {
                            $banner->creative->creative_id($cr_id);
                        } else {
                            $self->_add_error(iget("Ошибка! Видео-дополнение не найдено."));
                        }
                    }
                    else {
                        $banner->creative->creative($video);
                        $banner->creative->creative_id($video->id);
                    }

                    if ($creative->has_creative) {
                        my $vr_layout = validate_video_additions_layout_id($banner->banner_type => $creative->creative);
                        if ($vr_layout) {
                            $self->_add_error($vr_layout);
                        }
                    }
                }
            }
        }

        # РМП баннер
        if ($banner->banner_type eq 'mobile_content') {
            if (exists $user_banner->{reflected_attrs} || $is_new_banner) {
                $banner->reflected_attrs($user_banner->{reflected_attrs});
            }
            if (exists $user_banner->{primary_action}) {
                $banner->primary_action($user_banner->{primary_action});
            }
        }

        # Перфоманс баннер
        if ($banner->banner_type eq 'performance') {
            if (exists $user_banner->{creative_id} || $is_new_banner) {
                $banner->creative_id($user_banner->{creative_id});
                $banner->creative($self->_ex_creative_by_id->{$user_banner->{creative_id}});
            }
        }

        # TODO DIRECT-67003 понять что тут нужно для нашего нового типа
        if (!defined $user_banner->{ad_type} || ($ad_type ne 'image_ad' && $ad_type ne 'mobile_content') ) {
            if (exists $user_banner->{hash_flags}) {
                my $user_flags = $user_banner->{hash_flags};
                $banner->flags(map { $_ => $user_flags->{$_} } grep { defined $user_flags->{$_} } qw/age/);
            } elsif ($is_new_banner) {
                $banner->_flags(undef);
            }
        }

        push @banners, $banner;
    }

    return \@banners;
}

sub _prepare_vcard_from_user_data {
    my ($self, $banner, $user_vcard) = @_;

    my ($vcard, $is_new_vcard);

    if ($banner->has_vcard) {
        $vcard = $banner->vcard->clone;
    } else {
        $vcard = Direct::Model::VCard->new(id => 0, campaign_id => $self->campaign_id, user_id => $self->chief_uid);
        $is_new_vcard = 1;
    }

    for my $field (
        qw/country city street house build apart metro/,
        qw/name contactperson contact_email worktime/,
        qw/country_code city_code phone ext/,
        qw/im_client im_login extra_message ogrn/,
        qw/manual_point manual_bounds/,
    ) {
        next unless exists $user_vcard->{$field};
        $user_vcard->{$field} = smartstrip2($user_vcard->{$field});
        $user_vcard->{$field} = undef if defined $user_vcard->{$field} && !length $user_vcard->{$field};
    }

    $vcard->country($user_vcard->{country}) if exists $user_vcard->{country} || $is_new_vcard;
    $vcard->city($user_vcard->{city}) if exists $user_vcard->{city} || $is_new_vcard;
    $vcard->street($user_vcard->{street}) if exists $user_vcard->{street} || $is_new_vcard;
    $vcard->house($user_vcard->{house}) if exists $user_vcard->{house} || $is_new_vcard;
    $vcard->building($user_vcard->{build}) if exists $user_vcard->{build} || $is_new_vcard;
    $vcard->apartment($user_vcard->{apart}) if exists $user_vcard->{apart} || $is_new_vcard;
    $vcard->metro($user_vcard->{metro}) if exists $user_vcard->{metro} || $is_new_vcard;
    $vcard->name($user_vcard->{name}) if exists $user_vcard->{name} || $is_new_vcard;
    $vcard->contact_person($user_vcard->{contactperson}) if exists $user_vcard->{contactperson} || $is_new_vcard;
    $vcard->contact_email($user_vcard->{contact_email}) if exists $user_vcard->{contact_email} || $is_new_vcard;
    $vcard->work_time($user_vcard->{worktime}) if exists $user_vcard->{worktime} || $is_new_vcard;

    # Наличие телефона в визитке считаем по полю `phone`. Возможно, этот момент нужно исправить.
    $vcard->phone(VCards::compile_phone(hash_cut $user_vcard, @VCards::PHONE_FIELDS)) if exists $user_vcard->{phone} || $is_new_vcard;

    $vcard->im_client($user_vcard->{im_client}) if exists $user_vcard->{im_client} || $is_new_vcard;
    $vcard->im_login($user_vcard->{im_login}) if exists $user_vcard->{im_login} || $is_new_vcard;
    $vcard->extra_message($user_vcard->{extra_message}) if exists $user_vcard->{extra_message} || $is_new_vcard;
    $vcard->ogrn($user_vcard->{ogrn}) if exists $user_vcard->{ogrn} || $is_new_vcard;

    # $is_new_vcard не используем, чтобы дать возможность указать визитку без ручной точки
    # с подхватом существующей с, возможно, ручной точкой
    $vcard->manual_point($user_vcard->{manual_point}) if exists $user_vcard->{manual_point};
    $vcard->manual_bounds($user_vcard->{manual_bounds}) if exists $user_vcard->{manual_bounds};

    # Если визитка изменилась, то сбросим айдишник (т.к. визитки иммутабельны)
    # Эта строка важна, т.к. в дальнейшем валидируются только измененные визитки (т.е. без айдишника)
    $vcard->id(0) if !$is_new_vcard && $vcard->is_changed;

    return $vcard;
}

sub _prepare_sitelinks_set_from_user_data {
    my ($self, $banner, $user_sitelinks) = @_;

    my @sitelinks;
    for my $user_sl (@$user_sitelinks) {
        my $tl_id;
        if (exists $user_sl->{turbolanding}) {
            $tl_id = $user_sl->{turbolanding}->{id};
        }
        elsif(exists $user_sl->{tl_id}) {
            $tl_id = $user_sl->{tl_id};
        }
        
        next if !($user_sl->{title} =~ /\S/) || !($user_sl->{href} =~ /\S/ || $tl_id);

        if ($tl_id) {
            my $existing_turbolanding;
            $existing_turbolanding = $self->_ex_turbolandings()->{$tl_id} if $self->_ex_turbolandings();
            $user_sl->{turbolanding}->{href} = $existing_turbolanding ? $existing_turbolanding->href : '';
            
            $user_sl->{turbolanding}->{client_id} = $self->client_id if $user_sl->{turbolanding};
        }
              
        push @sitelinks, Direct::Model::Sitelink->new(
            id => 0,
            title => smartstrip2($user_sl->{title}),
            description => smartstrip2($user_sl->{description}),
            href => URLDomain::clear_banner_href($user_sl->{href}, $user_sl->{url_protocol}),
            turbolanding => $user_sl->{turbolanding},
        );
    }

    return undef if !@sitelinks;

    if ($banner->has_sitelinks_set) {
        # Если сайтлинки не изменились, то вернем оригинальный сет
        my $sitelinks_eq = ! Sitelinks::compare_sitelinks(
            [map { $_->to_db_hash } @sitelinks],
            [map { $_->to_db_hash } @{$banner->sitelinks_set->links}],
        );
        return $banner->sitelinks_set if $sitelinks_eq;
    }

    return Direct::Model::SitelinksSet->new(id => 0, client_id => $self->client_id, links => \@sitelinks);
}

sub _prepare_turbolanding_from_user_data {
    my ($self, $banner, $user_turbolanding) = @_;

    my %landing_fields;
    $landing_fields{id} = $user_turbolanding->{id};
    @landing_fields{qw/bid cid client_id/} = ($banner->id, $banner->campaign_id, $banner->client_id);
    if ( $banner->has_old && $banner->old->has_turbolanding
        && $banner->old->turbolanding->id == $landing_fields{id} ) {
            #Если у баннера турболендинг не менялся - возьмем status_moderate от старой версии баннера
            $landing_fields{status_moderate} = $banner->old->turbolanding->status_moderate;
    }
    my $existing_turbolanding;
    $existing_turbolanding = $self->_ex_turbolandings()->{$landing_fields{id}} if $self->_ex_turbolandings();
    $landing_fields{href} = $existing_turbolanding ? $existing_turbolanding->href : '';
    
    return Direct::Model::TurboLanding::Banner->new(%landing_fields);
}

sub _prepare_keywords_from_user_data {
    my ($self, $adgroup, $user_keywords) = @_;

    return [] unless @{$user_keywords // []};

    my @keywords;
    my $ex_keyword_by_id = {map { $_->id => $_ } @{$self->_ex_keywords_by_gid->{$adgroup->id} // []}};

    for my $user_keyword (@$user_keywords) {
        my $kw_id = $user_keyword->{id};

        # Пропускаем объекты с выставленным флагом `_delete`
        next if $user_keyword->{_delete};

        my ($keyword, $is_new_keyword);

        #
        # Создание объекта Direct::Model::Keyword
        #
        if ($kw_id) {
            $keyword = $ex_keyword_by_id->{$kw_id}->clone;
            $keyword->old($ex_keyword_by_id->{$kw_id});
        } else {
            $keyword = Direct::Model::Keyword->new(id => 0, adgroup_id => $adgroup->id, campaign_id => $self->campaign_id);
            $is_new_keyword = 1;
            if (exists $user_keyword->{showsForecast} && $user_keyword->{showsForecast}) {
                $keyword->{shows_forecast} = $user_keyword->{showsForecast};
            }
        }

        $keyword->adgroup($adgroup);

        #
        # Применение пользовательских данных
        #
        $keyword->is_suspended(!!$user_keyword->{is_suspended}) if exists $user_keyword->{is_suspended} || $is_new_keyword;

        # Обработка текста фразы
        if (exists $user_keyword->{phrase} || $is_new_keyword) {
            # Разбиваем текст на ключевые слова и минус-слова
            my ($plus_words, $minus_words) = map { $_ // '' } (split /(?:^|\s)\-/, $user_keyword->{phrase}, 2)[0,1];
            $minus_words = MinusWords::polish_minus_words($minus_words, add_minus => 1);
            $plus_words = Direct::PhraseTools::polish_phrase_text($plus_words, $minus_words);

            # Обработанный текст фразы
            my $phrase = join ' ', (length $plus_words ? $plus_words : ()), $minus_words;

            if (defined (my $phrase_props = PhraseText::get_phrase_props($phrase))) {
                $keyword->text($phrase_props->{phrase});
                $keyword->normalized_text($phrase_props->{norm_phrase});
                $keyword->words_count($phrase_props->{numword});
            } else {
                # Очевидно сработает валидация
                $keyword->text($phrase);
                $keyword->normalized_text('');
                $keyword->words_count(0);
            }
        }

        if ($self->campaign->{strategy}->{is_autobudget}) {
            $keyword->autobudget_priority($user_keyword->{autobudgetPriority} || undef) if exists $user_keyword->{autobudgetPriority} || $is_new_keyword;
        } else {
            if (exists $user_keyword->{price} || $is_new_keyword) {
                $keyword->price($user_keyword->{price} || 0);
            }
            if (exists $user_keyword->{price_context} || $is_new_keyword) {
                $keyword->price_context($user_keyword->{price_context} || 0);
            }

            if ($is_new_keyword) {
                # если показы на поиске отключены, у новой фразы поисковая ставка должна быть нулевой
                if ($self->campaign->{platform} eq 'context') {
                    $keyword->price(0);
                }
                # если стратегия не подразумевает ручной ставки в сети, у новой фразы ставка в сетях должна быть нулевой
                if (!($self->campaign->{platform} eq 'context'
                      || ($self->campaign->{platform} eq 'both' && $self->campaign->{strategy}->{name} eq 'different_places')
                     )
                ) {
                    $keyword->price_context(0);
                }
            }
        }

        for (1 .. 2) {
            $user_keyword->{'param'.$_} = $user_keyword->{'Param'.$_}
                if exists $user_keyword->{'Param'.$_} && !exists $user_keyword->{'param'.$_};
        }
        $keyword->href_param1($user_keyword->{param1}) if exists $user_keyword->{param1} || $is_new_keyword;
        $keyword->href_param2($user_keyword->{param2}) if exists $user_keyword->{param2} || $is_new_keyword;

        # Заполняем также `ctr_source_id` (актуально только для новых фраз)
        $keyword->ctr_source_id($user_keyword->{ctr_source_id}) if $is_new_keyword;

        push @keywords, $keyword;
    }

    Direct::Keywords->prepare(\@keywords);

    return \@keywords;
}

sub _prepare_relevance_match_from_user_data {
    my ($self, $adgroup, $user_relevance_matches) = @_;

    return [] if !@{$user_relevance_matches // []};

    my @relevance_matches;
    my $ex_relevance_matches_by_id = {map { $_->id => $_ } @{$self->_ex_relevance_matches_by_gid->{$adgroup->id} // []}};

    my $has_extended_relevance_match = Campaign::has_context_relevance_match_feature($self->campaign->{type}, $self->client_id);
    
    for my $user_relevance_match (@$user_relevance_matches) {
        # Пропускаем объекты с выставленным флагом `_delete`
        next if $user_relevance_match->{_delete};

        my $bid_id = $user_relevance_match->{bid_id};

        my ($relevance_match, $is_new_relevance_match);
        if ($bid_id) {
            $relevance_match = $ex_relevance_matches_by_id->{$bid_id}->clone;
            $relevance_match->old($ex_relevance_matches_by_id->{$bid_id});
        } else {
            $relevance_match = Direct::Model::BidRelevanceMatch->new(id => 0, adgroup_id => $adgroup->id, campaign_id => $self->campaign_id);
            $is_new_relevance_match = 1;
        }
        $relevance_match->adgroup($adgroup);

        #
        # Применение пользовательских данных
        #
        $relevance_match->is_suspended(!!$user_relevance_match->{is_suspended}) if exists $user_relevance_match->{is_suspended} || $is_new_relevance_match;
        
        if ($self->campaign->{strategy}->{is_autobudget}) {
            $relevance_match->autobudget_priority($user_relevance_match->{autobudgetPriority} || undef)
                if exists $user_relevance_match->{autobudgetPriority} || $is_new_relevance_match;
        }
        else {
            if (exists $user_relevance_match->{price} || $is_new_relevance_match) {
                my $price = $user_relevance_match->{price} || 0;
                $relevance_match->price($price);
            }
            if (exists $user_relevance_match->{price_context} || $is_new_relevance_match) {
                my $price_context;
                if ($has_extended_relevance_match 
                        && ($self->campaign->{platform} eq 'context'
                        || ($self->campaign->{platform} eq 'both' && $self->campaign->{strategy}->{name} eq 'different_places' ))
                ) {
                    $price_context = $user_relevance_match->{price_context};
                }

                $relevance_match->price_context($price_context || 0);
            }
            
        }
        
        $relevance_match->href_param1($user_relevance_match->{param1}) if exists $user_relevance_match->{param1} || $is_new_relevance_match;
        $relevance_match->href_param2($user_relevance_match->{param2}) if exists $user_relevance_match->{param2} || $is_new_relevance_match;

        push @relevance_matches, $relevance_match;
    }

    return \@relevance_matches;
}

sub _prepare_retargetings_from_user_data {
    my ($self, $adgroup, $user_retargetings) = @_;

    return [] if !@{$user_retargetings // []};

    my @retargetings;
    my $ex_retargeting_by_id = {map { $_->id => $_ } @{$self->_ex_retargetings_by_gid->{$adgroup->id} // []}};

    for my $user_ret (@$user_retargetings) {
        my $ret_id = $user_ret->{ret_id};

        # Пропускаем объекты с выставленным флагом `_delete`
        next if $user_ret->{_delete};

        my ($retargeting, $is_new_retargeting);

        #
        # Создание объекта Direct::Model::Retargeting
        #
        if ($ret_id) {
            $retargeting = $ex_retargeting_by_id->{$ret_id}->clone;
            $retargeting->old($ex_retargeting_by_id->{$ret_id});
        } else {
            $retargeting = Direct::Model::Retargeting->new(id => 0, adgroup_id => $adgroup->id, campaign_id => $self->campaign_id);
            $is_new_retargeting = 1;
        }

        $retargeting->adgroup($adgroup);

        #
        # Применение пользовательских данных
        #
        $retargeting->ret_cond_id($user_ret->{ret_cond_id}) if exists $user_ret->{ret_cond_id};
        $retargeting->is_suspended(!!$user_ret->{is_suspended}) if exists $user_ret->{is_suspended} || $is_new_retargeting;

        if (!$self->campaign->{strategy} || !$self->campaign->{strategy}->{is_autobudget}) {
            $retargeting->price_context($user_ret->{price_context} || 0) if exists $user_ret->{price_context} || $is_new_retargeting;
        } else {
            $retargeting->autobudget_priority($user_ret->{autobudgetPriority} || undef) if exists $user_ret->{autobudgetPriority} || $is_new_retargeting;
        }

        # Запишем ret_cond // нужен для валидации
        $retargeting->ret_cond($self->_ex_ret_cond_by_id->{$retargeting->ret_cond_id}->clone) if defined $user_ret->{ret_cond_id};

        push @retargetings, $retargeting;
    }

    return \@retargetings;
}

sub _prepare_target_interests_from_user_data {
    my ($self, $adgroup, $user_target_interests) = @_;

    return [] if !@{$user_target_interests // []};

    my @target_interests;
    my $ex_target_interests_by_id = {map { $_->id => $_ } @{$self->_ex_target_interests_by_gid->{$adgroup->id} // []}};

    for my $user_target_interest (@$user_target_interests) {
        my $ret_id = $user_target_interest->{ret_id};

        my ($target_interest, $is_new_target_interest);

        #
        # Создание объекта Direct::Model::TargetInterest
        #
        if ($ret_id) {
            $target_interest = $ex_target_interests_by_id->{$ret_id}->clone;
            $target_interest->old($ex_target_interests_by_id->{$ret_id});
        } else {
            $target_interest = Direct::Model::TargetInterest->new(id => 0, adgroup_id => $adgroup->id, campaign_id => $self->campaign_id);
            $is_new_target_interest = 1;
        }

        $target_interest->adgroup($adgroup);

        #
        # Применение пользовательских данных
        #
        $target_interest->target_category_id($user_target_interest->{target_category_id}) if exists $user_target_interest->{target_category_id} || $is_new_target_interest;
        $target_interest->is_suspended(!!$user_target_interest->{is_suspended}) if exists $user_target_interest->{is_suspended} || $is_new_target_interest;

        if (!$self->campaign->{strategy} || !$self->campaign->{strategy}->{is_autobudget}) {
            $target_interest->price_context($user_target_interest->{price_context} || 0) if exists $user_target_interest->{price_context} || $is_new_target_interest;
        } else {
            $target_interest->autobudget_priority($user_target_interest->{autobudgetPriority} || undef) if exists $user_target_interest->{autobudgetPriority} || $is_new_target_interest;
        }

        push @target_interests, $target_interest;
    }

    return \@target_interests;
}


=head2 prepare_dyn_conds_from_user_data

Публичная обертка для вызова prepare_dyn_conds_from_user_data из DoCmdAdGroup::cmd_ajaxValidateDynamicConditions

=cut

sub prepare_dyn_conds_from_user_data {
    return _prepare_dyn_conds_from_user_data(@_);
}

sub _prepare_dyn_conds_from_user_data {
    my ($self, $adgroup, $user_dyn_conds) = @_;

    return [] unless @{$user_dyn_conds // []};

    my @dynamic_conditions;
    my $ex_dyn_cond_by_id = {map { $_->id => $_ } @{$self->_ex_dyn_conds_by_gid->{$adgroup->id} // []}};

    for my $user_dyn_cond (@$user_dyn_conds) {
        my $dyn_id = $user_dyn_cond->{dyn_id};

        # Пропускаем объекты с выставленным флагом `_delete`
        next if $user_dyn_cond->{_delete};

        my ($dyn_cond, $is_new_dyn_cond);

        #
        # Создание объекта Direct::Model::DynamicCondition
        #
        if ($dyn_id) {
            $dyn_cond = $ex_dyn_cond_by_id->{$dyn_id}->clone;
        } else {
            $dyn_cond = Direct::Model::DynamicCondition->new(id => 0, adgroup_id => $adgroup->id,
                ( $adgroup->has_feed_id ? (feed_id => $adgroup->feed_id) : () ));
            $is_new_dyn_cond = 1;
        }

        $dyn_cond->adgroup($adgroup);

        #
        # Применение пользовательских данных
        #
        $dyn_cond->condition_name(smartstrip2($user_dyn_cond->{condition_name}) // '') if exists $user_dyn_cond->{condition_name} || $is_new_dyn_cond;
        my $rule_type = $adgroup->get_class_for_condition_rules();
        my $filter_type = '';
        if ($adgroup->has_feed_id && $adgroup->feed_id) {
            if (!$self->client_id) {
                $self->client_id($self->campaign->{ClientID});
            }
            $self->_ex_feed_by_id(Direct::Feeds->get_by($self->client_id)->items_by('id'));
            my $feed = $self->_ex_feed_by_id->{$adgroup->feed_id};
            unless ($feed) {
                die "feed # @{[$adgroup->feed_id]} not found (pid = @{[$adgroup->id]})";
            }
            $filter_type = $feed->business_type . '_'. $feed->feed_type;
        }
        $dyn_cond->condition([
            map { $rule_type->new(%$_, filter_type => $filter_type) } @{$user_dyn_cond->{condition}}
        ]) if exists $user_dyn_cond->{condition} || $is_new_dyn_cond;

        $dyn_cond->is_suspended(!!$user_dyn_cond->{is_suspended}) if exists $user_dyn_cond->{is_suspended} || $is_new_dyn_cond;
        if ($self->campaign->{strategy}->{is_autobudget}) {
            # 3 -- значение приоритета автобюджета по умолчанию
            $dyn_cond->autobudget_priority($user_dyn_cond->{autobudgetPriority} || 3) if exists $user_dyn_cond->{autobudgetPriority} || $is_new_dyn_cond;
        } else {
            if (exists $user_dyn_cond->{price} || $is_new_dyn_cond) {
                my $price = $self->campaign->{platform} eq 'context' ? 0 : $user_dyn_cond->{price};
                $dyn_cond->price($price || 0);
            }
            if (exists $user_dyn_cond->{price_context} || $is_new_dyn_cond) {
                my $price_context;
                if ($self->campaign->{platform} eq 'context'
                    || ($self->campaign->{platform} eq 'both' && $self->campaign->{strategy}->{name} eq 'different_places')) {

                    $price_context = $user_dyn_cond->{price_context};
                } else {
                    $price_context = 0;
                }
                $dyn_cond->price_context($price_context || 0);
            }
        }
        $dyn_cond->from_tab($user_dyn_cond->{from_tab}) if exists $user_dyn_cond->{from_tab};
        $dyn_cond->available($user_dyn_cond->{available} ? 1 : 0);

        push @dynamic_conditions, $dyn_cond;
    }

    return \@dynamic_conditions;
}

sub _prepare_perf_filters_from_user_data {
    my ($self, $adgroup, $user_perf_filters) = @_;

    return [] unless @{$user_perf_filters // []};

    my @performance_filters;
    my $ex_perf_filter_by_id = {map { $_->id => $_ } @{$self->_ex_perf_filters_by_gid->{$adgroup->id} // []}};

    for my $user_perf_filter (@$user_perf_filters) {
        my $perf_filter_id = $user_perf_filter->{perf_filter_id};

        # Пропускаем объекты с выставленным флагом `_delete`
        next if $user_perf_filter->{_delete};

        my ($perf_filter, $is_new_perf_filter);

        #
        # Создание объекта Direct::Model::PerformanceFilter
        #
        if ($perf_filter_id) {
            $perf_filter = $ex_perf_filter_by_id->{$perf_filter_id}->clone;
        } else {
            $perf_filter = Direct::Model::PerformanceFilter->new(id => 0, adgroup_id => $adgroup->id, campaign_id => $self->campaign_id);
            $is_new_perf_filter = 1;
        }

        $perf_filter->adgroup($adgroup);

        #
        # Применение пользовательских данных
        #
        $perf_filter->filter_name(smartstrip2($user_perf_filter->{filter_name})) if exists $user_perf_filter->{filter_name} || $is_new_perf_filter;
        $perf_filter->target_funnel($user_perf_filter->{target_funnel}) if exists $user_perf_filter->{target_funnel} || $is_new_perf_filter;
        $perf_filter->is_suspended(!!$user_perf_filter->{is_suspended}) if exists $user_perf_filter->{is_suspended} || $is_new_perf_filter;
        $perf_filter->from_tab($user_perf_filter->{from_tab}) if exists $user_perf_filter->{from_tab};

        my $feed = $self->_ex_feed_by_id->{$adgroup->{feed_id}};
        unless ($feed) {
            die "feed_id is missing or invalid";
        }
        my $filter_type = $feed->business_type . '_' . $feed->feed_type;

        $perf_filter->condition([
            map { Direct::Model::PerformanceFilter::Rule->new(%$_, filter_type => $filter_type) } @{$user_perf_filter->{condition}}
        ]) if exists $user_perf_filter->{condition} || $is_new_perf_filter;
        $perf_filter->available(!!$user_perf_filter->{available}) if exists $user_perf_filter->{available};

        if (exists $user_perf_filter->{retargeting} || $is_new_perf_filter) {
            $perf_filter->retargeting(
                $user_perf_filter->{retargeting}
                    ? Direct::Model::RetargetingCondition->new(id => $user_perf_filter->{retargeting}->{ret_cond_id})
                    : undef
            );
        }

        # Ставки
        $perf_filter->price_cpc($user_perf_filter->{price_cpc} || 0) if exists $user_perf_filter->{price_cpc} || $is_new_perf_filter;
        $perf_filter->price_cpa($user_perf_filter->{price_cpa} || 0) if exists $user_perf_filter->{price_cpa} || $is_new_perf_filter;
        $perf_filter->autobudget_priority($user_perf_filter->{autobudgetPriority} || undef) if exists $user_perf_filter->{autobudgetPriority} || $is_new_perf_filter;

        push @performance_filters, $perf_filter;
    }

    return \@performance_filters;
}

sub _process_bs_data {
    my ($self) = @_;

    return if !$self->campaign_id;
    return unless $self->is_text_campaign || $self->is_mobile_content_campaign;

    my @keywords = map { @{$_->{keywords} // []} } @{$self->_data_to_apply};

    # Не запрашиваем данные по не изменненым ключевикам
    return if !@keywords || all { $_->id && !$_->is_changed } @keywords;

    # Вычислим ctr_source
    if (my @keywords_with_ctr_source = grep { $_->has_ctr_source_id && $_->ctr_source_id } @keywords) {
        my @kw_ids = map { $_->ctr_source_id } @keywords_with_ctr_source;
        my $history = BS::History::get_keywords_with_history({ph_ids => \@kw_ids, cid => $self->campaign_id});
        my %cumulative_ctr = map { $_->{id} => $_ } @$history;
        for my $kw (@keywords_with_ctr_source) {
            my $ctr_source = $cumulative_ctr{$kw->ctr_source_id}->{phraseIdHistory};
            next unless $ctr_source;
            $kw->ctr_source($ctr_source);
        }
    }

    # Если кампания автобюджетая, то дальнейшие шаги не требуется
    return if ($self->campaign->{autobudget} // 'No') eq 'Yes';

    # Сходим в торги, чтобы получить актуальные цены для фраз
    Direct::BsData->enrich_smart_data_items_with_bs_data($self, bs_auction => 1, bs_stat => 0);

    for my $keyword (@keywords) {
        if (
            $keyword->has_bs_data && defined $keyword->bs_data &&
            (all { defined $keyword->bs_data->{$_} } qw/guarantee premium/) && $keyword->price
        ) {
            my $place = PlacePrice::calcPlace($keyword->price, $keyword->bs_data->{guarantee}, $keyword->bs_data->{premium});
            $keyword->place($place);
        }
        $keyword->place(undef) if !$keyword->has_place;
    }

    return;
}

=head2 _validate

=cut

sub _validate {
    my ($self) = @_;

    # Результат валидации всех переданных пользователем групп
    my $vr_main = $self->validation_result($self->_validate_adgroups());

    $self->_set_vcards_validation_result();

    my $it = each_array( @{$self->_data_to_apply}, @{$self->_user_adgroups}, @{$vr_main->get_objects_results} );
    while ( my ($data_item, $user_adgroup, $vr ) = $it->()) {
        my $adgroup = $data_item->{adgroup};

        $vr->add(banners => $self->_validate_banners($adgroup, $data_item->{banners}, $data_item->{banners_to_delete}));

        if (any { $adgroup->adgroup_type eq $_ } qw/base mobile_content mcbanner cpm_banner/) {
            $vr->add(keywords => $self->_validate_keywords($adgroup, $data_item->{keywords}));
        }
        if (any { $adgroup->adgroup_type eq $_ } qw/base mobile_content/) {
            $vr->add(retargetings => $self->_validate_retargetings($adgroup, $data_item->{retargetings}));
        }
        if ($adgroup->adgroup_type =~ /cpm_(banner|video)/) {
            # В CPM группах сейчас допустимы либо только одно условие типа СоцДем,
            # либо только обычные ретаргетинги (если клиент использовал фразы)
            if (any {defined $_->{type} && $_->{type} eq 'interests'} @{$user_adgroup->{retargetings}}) {
                if (any {!defined $_->{type} || $_->{type} ne 'interests'} @{$user_adgroup->{retargetings}}) {
                    die 'Socdem retargetings cannot be mixed with another retargetings';
                }
                # Проверяем соцдем-таргетинг через ручку в Int API
                $vr->add(retargetings => $self->_validate_socdem_retargetings_for_cpm_campaign($user_adgroup->{retargetings}));
            } else {
                # Проверяем ретаргетинги обычным методом
                $vr->add(retargetings => $self->_validate_retargetings($adgroup, $data_item->{retargetings}));
            }
        }
        if (any { $adgroup->adgroup_type eq $_ } qw/base mobile_content/) {
            $vr->add(relevance_matches => $self->_validate_relevance_matches($adgroup, $data_item->{relevance_matches}));
            $vr->add(target_interests => $self->_validate_target_interests($adgroup, $data_item->{target_interests}));
        }
        if ($adgroup->adgroup_type eq 'dynamic') {
            $vr->add(dynamic_conditions => $self->_validate_dynamic_conditions($adgroup, $data_item->{dynamic_conditions}));
        } elsif ($adgroup->adgroup_type eq 'performance') {
            $vr->add(performance_filters => $self->_validate_performance_filters($adgroup, $data_item->{performance_filters}));
        }
    }
    $vr_main->process_descriptions(Direct::AdGroups2::WEB_FIELD_NAMES);

    return $self;
}

sub _validate_adgroups {
    my ($self) = @_;

    my (%adgroup_idx, %adgroups_to, %vr_adgroups_of);
    my $content_lang = ($self->campaign_id) ? CampaignQuery->get_campaign_data(cid => $self->campaign_id, [qw/content_lang/], get_also_empty_campaigns => 1)->{content_lang} : undef;
    my $campaign;

    if ($self->is_cpm_deals_campaign) {
        my $is_yandex_page = CampaignTools::get_cpm_deals_is_yandex_page_flag($self->campaign_id);
        $campaign = Direct::Model::CampaignCpmDeals->new(
            id => $self->campaign_id,
            content_lang => $content_lang,
            is_yandex_page => $is_yandex_page,
        );
    } else {
        $campaign = new Direct::Model::Campaign(
            id => $self->campaign_id,
            content_lang => $content_lang,
            campaign_type => ($self->campaign->{mediaType} || $self->campaign->{type})
        );
    }

    # Подготовим группы для валидации по-действиям
    for my $data_item (@{$self->_data_to_apply}) {
        my $adgroup = $data_item->{adgroup};
        $adgroup->campaign($campaign);
        my $banners = $data_item->{banners} // [];
        my $changed_bids = {map { ($_->id => 1) } grep { $_->id } @$banners};

        if (!$adgroup->id) {
            # для пропуска проверки гео и языка баннеров и гео группы и гео креатива
            # (непосредственная проверка в _validate_banners)
            $adgroup->banners([]);
            push @{$adgroups_to{create}}, $adgroup;
            $adgroup_idx{create}->{$adgroup} = $#{$adgroups_to{create}};
        } else {
            # Клонируем группу, чтобы избежать потенциальных циклических зависимостей
            my $adgroup_cloned = $adgroup->clone;
            # Добавим баннеры, которые не изменялись
            $adgroup_cloned->banners([grep { !$changed_bids->{$_->id} } @{$self->_ex_banners_by_gid->{$adgroup->id} // []}]);
            push @{$adgroups_to{update}}, $adgroup_cloned;
            $adgroup_idx{update}->{$adgroup} = $#{$adgroups_to{update}};
        }
    }

    # Валидация добавления новых групп
    if ($adgroups_to{create}) {
        my $adgroups_count = $self->campaign_id ? get_one_field_sql(PPC(cid => $self->campaign_id), "SELECT count(pid) FROM phrases WHERE cid = ?", $self->campaign_id) : 0;

        my $validate_add_adgroups_func;
        if ($self->is_text_campaign) {
            $validate_add_adgroups_func = \&validate_add_text_adgroups;
        } elsif ($self->is_dynamic_campaign) {
            $validate_add_adgroups_func = \&validate_add_dynamic_adgroups;
        } elsif ($self->is_mobile_content_campaign) {
            $validate_add_adgroups_func = \&validate_add_mobile_adgroups;
        } elsif ($self->is_performance_campaign) {
            $validate_add_adgroups_func = \&validate_add_performance_adgroups;
        } elsif ($self->is_mcbanner_campaign) {
            $validate_add_adgroups_func = \&validate_add_mcbanner_adgroups;
        } elsif ($self->is_cpm_banner_campaign || $self->is_cpm_deals_campaign) {
            $validate_add_adgroups_func = \&validate_add_cpm_banner_adgroups;
        }

        $vr_adgroups_of{create} = $validate_add_adgroups_func->(
            $adgroups_to{create} // [],
            Direct::Model::Campaign->from_db_hash({
                adgroups_count => $adgroups_count,
                adgroups_limit => $self->client->adgroups_limit,
            }, \{}, with => 'AdGroupsCount')
        );
    } else {
        $vr_adgroups_of{create} = Direct::ValidationResult->new();
    }

    # Валидация обновления существующих групп
    if ($adgroups_to{update}) {
        if ($self->is_text_campaign) {
            $vr_adgroups_of{update} = validate_update_text_adgroups($adgroups_to{update});
        } elsif ($self->is_dynamic_campaign) {
            $vr_adgroups_of{update} = validate_update_dynamic_adgroups($adgroups_to{update});
        } elsif ($self->is_mobile_content_campaign) {
            $vr_adgroups_of{update} = validate_update_mobile_adgroups($adgroups_to{update});
        } elsif ($self->is_performance_campaign) {
            $vr_adgroups_of{update} = validate_update_performance_adgroups($adgroups_to{update});
        } elsif ($self->is_mcbanner_campaign) {
            $vr_adgroups_of{update} = validate_update_mcbanner_adgroups($adgroups_to{update})
        } elsif ($self->is_cpm_banner_campaign || $self->is_cpm_deals_campaign) {
            $vr_adgroups_of{update} = validate_update_cpm_banner_adgroups($adgroups_to{update})
        }
    } else {
        $vr_adgroups_of{update} = Direct::ValidationResult->new();
    }

    # Соберём результаты
    my $vr_adgroups = Direct::ValidationResult->new();

    $vr_adgroups->add_generic([@{$vr_adgroups_of{create}->get_generic_errors}, @{$vr_adgroups_of{create}->get_generic_warnings}]);
    $vr_adgroups->add_generic([@{$vr_adgroups_of{update}->get_generic_errors}, @{$vr_adgroups_of{update}->get_generic_warnings}]);

    my $nested_objects = $vr_adgroups->nested_objects;
    for my $data_item (@{$self->_data_to_apply}) {
        my $adgroup = $data_item->{adgroup};

        push @$nested_objects, !$adgroup->id
            ? $vr_adgroups_of{create}->nested_objects->[ $adgroup_idx{create}->{$adgroup} ]
            : $vr_adgroups_of{update}->nested_objects->[ $adgroup_idx{update}->{$adgroup} ];
    }

    # Workaround for ValidationResult
    for (my $i = 0; $i <= $#$nested_objects; $i++) { $nested_objects->[$i]->{position} = $i; }

    $vr_adgroups->process_objects_descriptions(Direct::AdGroups2->WEB_FIELD_NAMES);

    # Провалидируем теги
    $self->_validate_tags($vr_adgroups);

    return $vr_adgroups;
}

sub _validate_tags {
    my ($self, $vr_adgroups) = @_;

    # Проверим суммарное количество тегов на кампании (с учетом новых)
    my $new_tags_on_campaign_count = xuniq { $_->tag_name } grep { !$_->id } map { @{$_->{adgroup}->tags} } grep { $_->{adgroup}->has_tags } @{$self->_data_to_apply};
    if (scalar(keys %{$self->_campaign_tag_id2name}) + $new_tags_on_campaign_count > $Tag::MAX_TAGS_FOR_CAMPAIGN) {
        $vr_adgroups->add_generic(error_ReachLimit(iget('Превышено допустимое количество меток на кампанию')));
    }

    # А теперь проверим теги на группах
    for (my $i = 0; $i < @{$self->_data_to_apply}; $i++) {
        my $adgroup = $self->_data_to_apply->[$i]->{adgroup};
        my $vr_adgroup = $vr_adgroups->nested_objects->[$i];

        if ($adgroup->has_tags) {
            my $vr_tags = Direct::ValidationResult->new();
            for my $tag (@{$adgroup->tags}) {
                my $vr = $vr_tags->next;

                if ($tag->tag_name !~ /\S/) {
                    $vr->add_generic(error_EmptyField(iget('Название метки не должно быть пустой строкой')));
                } else {
                    if ($tag->tag_name =~ $Settings::DISALLOW_BANNER_LETTER_RE || $tag->tag_name =~ /,/) {
                        $vr->add_generic(error_InvalidChars(iget('В названии метки используются недопустимые символы')));
                    }
                    if (length($tag->tag_name) > $Tag::MAX_TAG_LENGTH) {
                        $vr->add_generic(error_MaxLength(iget('Превышена максимальная длина метки')));
                    }
                }
            }

            if (@{$adgroup->tags} > $Tag::MAX_TAGS_FOR_BANNER) {
                $vr_tags->add_generic(error_ReachLimit(iget('Превышено допустимое количество меток на группу')));
            }

            $vr_adgroup->add(tags => $vr_tags) if !$vr_tags->is_valid;
        }
    }

    return;
}

{
my %hosts_checked_cache;
my $hosts_checked_cache_age = 0;

sub _check_banner_hrefs_availability {
    my ($self, $banners) = @_;

    # (!) Проверяем один раз на домен

    # Урлы уже могли быть проверены через web интерфейс ajax ручкой (нам пришел подписанный результат)
    my $hosts_checked = {
        map { get_host($_->{href}) => 1 }
        grep { $_->{href} && $_->{domain} && $_->{domain_redir} && URLDomain::url_domain_checksign($_) }
        map { @{$_->{banners}} }
        @{$self->_user_adgroups}
    };

    my $hosts_to_check = {};
    for my $banner (@$banners) {
        if ($banner->is_href_supported && $banner->href && (!$banner->id || $banner->is_href_changed)) {
            $hosts_to_check->{get_host($banner->href)} //= $banner->href;
        }
    }

    my $errors_count = 0;
    my $max_errors_count = 5;
    my @redirect_check_queue_cache;

    while (my ($host, $url) = each %$hosts_to_check) {
        next if $hosts_checked->{$host};

        my $result;

        my ($redirect, $domain_redir) = RedirectCheckQueue::check_dict($url);
        if ($redirect) {
            $result = 1; # url is ok
        } elsif (defined $hosts_checked_cache{$host}) {
            $result = $hosts_checked_cache{$host};
        } else {
            my $x = URLDomain::get_url_domain($url, {check_for_http_status => 1});
            if ($x->{res}) {
                push @redirect_check_queue_cache, [$url, $x->{msg}, $x->{domain_redir}, $x->{redirect_result_href}];
                $result = 1;
            } else {
                $result = {url => $url, error => $x->{msg}};
            }
        }

        $hosts_checked->{$host} = $result;
        if ($hosts_checked_cache_age  > 5_000) {
            # сбрасываем кеш после превышения лимита обращений
            undef %hosts_checked_cache;
            $hosts_checked_cache_age = 0;
        } else {
            $hosts_checked_cache{$host} //= $result;
            $hosts_checked_cache_age++;
        }
        last if ref($result) && ++$errors_count > $max_errors_count;
    }

    RedirectCheckQueue::feed_dict(@redirect_check_queue_cache) if @redirect_check_queue_cache;

    # Возвращаем ответ в формате: {url => error, ...}
    return {
        map { @{$hosts_checked->{$_}}{qw/url error/} }
        grep { ref($hosts_checked->{$_}) }
        keys %$hosts_checked
    };
}

}

sub _validate_banners {
    my ($self, $adgroup, $banners, $banners_to_delete) = @_;

    my $vr_banners = Direct::ValidationResult->new();
    return $vr_banners unless @{$banners // []};

    my (%banner_idx, %banners_to, %vr_banners_of);

    # Проиндексируем баннеры для поиска результатов валидации
    for my $banner (@{$banners}) {
        if (!$banner->id) {
            push @{$banners_to{create}}, $banner;
            $banner_idx{create}->{$banner} = $#{$banners_to{create}};
        } else {
            push @{$banners_to{update}}, $banner;
            $banner_idx{update}->{$banner} = $#{$banners_to{update}};
        }
    }

    # Валидация добавления новых баннеров
    if ($banners_to{create}) {
        if ($adgroup->adgroup_type eq 'base') {
            $vr_banners_of{create} = validate_add_banners_text_adgroup($banners_to{create}, $adgroup, banners_count_to_delete => scalar(@$banners_to_delete));
        } elsif ($adgroup->adgroup_type eq 'dynamic') {
            $vr_banners_of{create} = validate_add_banners_dynamic_adgroup($banners_to{create}, $adgroup, banners_count_to_delete => scalar(@$banners_to_delete));
        } elsif ($adgroup->adgroup_type eq 'mobile_content') {
            $vr_banners_of{create} = validate_add_banners_mobile_adgroup($banners_to{create}, $adgroup, banners_count_to_delete => scalar(@$banners_to_delete));
        } elsif ($adgroup->adgroup_type eq 'performance') {
            $vr_banners_of{create} = validate_add_banners_performance_adgroup($banners_to{create}, $adgroup, banners_count_to_delete => scalar(@$banners_to_delete));
        } elsif ($adgroup->adgroup_type eq 'mcbanner') {
            $vr_banners_of{create} = validate_add_banners_mcbanner_adgroup($banners_to{create}, $adgroup, banners_count_to_delete => scalar(@$banners_to_delete));
        } elsif ($adgroup->adgroup_type =~ /cpm_(banner|video)/) {
            $vr_banners_of{create} = validate_add_banners_cpm_banner_adgroup($banners_to{create}, $adgroup,
                banners_count_to_delete => scalar(@$banners_to_delete), permitted_pixel_providers => $self->client->permitted_pixel_providers);
        }

        if ($adgroup->adgroup_type eq 'mobile_content'){
            $vr_banners_of{create}->process_objects_descriptions(Direct::Banners->WEB_MOBILE_CONTENT_FIELD_NAMES);
        }
        $vr_banners_of{create}->process_objects_descriptions(Direct::Banners->WEB_FIELD_NAMES);
    } else {
        $vr_banners_of{create} = Direct::ValidationResult->new();
    }

    # Валидация обновления существующих баннеров
    if ($banners_to{update}) {
        if ($adgroup->adgroup_type eq 'base') {
            $vr_banners_of{update} = validate_update_banners_text_adgroup($banners_to{update}, $adgroup);
        } elsif ($adgroup->adgroup_type eq 'dynamic') {
            $vr_banners_of{update} = validate_update_banners_dynamic_adgroup($banners_to{update}, $adgroup);
        } elsif ($adgroup->adgroup_type eq 'mobile_content') {
            $vr_banners_of{update} = validate_update_banners_mobile_adgroup($banners_to{update}, $adgroup);
        } elsif ($adgroup->adgroup_type eq 'performance') {
            $vr_banners_of{update} = validate_update_banners_performance_adgroup($banners_to{update}, $adgroup);
        } elsif ($adgroup->adgroup_type eq 'mcbanner') {
            $vr_banners_of{update} = validate_update_banners_mcbanner_adgroup($banners_to{update}, $adgroup)
        } elsif ($adgroup->adgroup_type =~ /cpm_(banner|video)/) {
            $vr_banners_of{update} = validate_update_banners_cpm_banner_adgroup($banners_to{update}, $adgroup,
                permitted_pixel_providers => $self->client->permitted_pixel_providers)
        }

        if ($adgroup->adgroup_type eq 'mobile_content'){
            $vr_banners_of{update}->process_objects_descriptions(Direct::Banners->WEB_MOBILE_CONTENT_FIELD_NAMES);
        }
        $vr_banners_of{update}->process_objects_descriptions(Direct::Banners->WEB_FIELD_NAMES);
    } else {
        $vr_banners_of{update} = Direct::ValidationResult->new();
    }

    # Валидация удаления баннеров
    if (@{$banners_to_delete // []}) {
        # Валидация удаления требует кампанию с заполненным полем is_in_bs_queue
        my $campaign = Direct::Campaigns->get($self->campaign_id, with_roles => 'BsQueue')->items->[0];

        if ($adgroup->adgroup_type eq 'performance') {
            my $vr = validate_delete_performance_banners($banners_to_delete, $adgroup, $campaign);
            if (!$vr->is_valid) {
                $vr_banners->add_generic(error_InconsistentState(iget("Один или несколько баннеров не могут быть удалены")));
            }
        } else {
            croak "Cannot validate deletion of banners for adgroup";
        }
    }

    # Соберём результаты
    $vr_banners->add_generic([@{$vr_banners_of{create}->get_generic_errors}, @{$vr_banners_of{create}->get_generic_warnings}]);
    $vr_banners->add_generic([@{$vr_banners_of{update}->get_generic_errors}, @{$vr_banners_of{update}->get_generic_warnings}]);

    my $nested_objects = $vr_banners->nested_objects;
    for my $banner (@$banners) {
        my $vr = !$banner->id
            ? $vr_banners_of{create}->nested_objects->[ $banner_idx{create}->{$banner} ]
            : $vr_banners_of{update}->nested_objects->[ $banner_idx{update}->{$banner} ];

        # Дополним результатом валидации визитки
        if ($banner->has_vcard && !$banner->vcard->id) {
            my $vr_vcard;
            if ($banner->vcard->{_vcard_validation_result}) {
                $vr_vcard = $banner->vcard->{_vcard_validation_result};
            } else {
                $vr_vcard = validate_vcards([$banner->vcard])->nested_objects->[0];
                $vr_vcard->process_descriptions(Direct::VCards->WEB_FIELD_NAMES);
                # Workaround for phone
                my $vr_vcard_phone = $vr_vcard->get_field_result("phone");
                if ($vr_vcard_phone && blessed($vr_vcard_phone) && $vr_vcard_phone->isa('Direct::ValidationResult')) {
                    $vr_vcard_phone->process_descriptions(Direct::VCards->WEB_FIELD_NAMES);
                }
            }
            $vr->add(vcard => $vr_vcard);
        }

        # Дополним результатом валидации сайтлинк-сета
        if ($banner->has_sitelinks_set) {
            $vr->add(sitelinks_set => validate_sitelinks_sets([$banner->sitelinks_set])->nested_objects->[0]);
        }

        push @$nested_objects, $vr;
    }

    # Workaround for ValidationResult
    for (my $i = 0; $i <= $#$nested_objects; $i++) { $nested_objects->[$i]->{position} = $i; }

    if (($self->is_text_campaign || $self->is_mcbanner_campaign || $self->is_cpm_banner_campaign || $self->is_cpm_deals_campaign) && $vr_banners->is_valid) {
        # Проверим доступность ссылок на баннерах (функция проверяет только новые/изменившееся урлы)
        my $hrefs_availability = $self->_check_banner_hrefs_availability($banners);

        for (my $i = 0; $i < @$banners; $i++) {
            my ($banner, $vr) = ($banners->[$i], $vr_banners->nested_objects->[$i]);
            next if !$banner->href;

            if (my $err = $hrefs_availability->{$banner->href}) {
                $vr->add(href => error_BadStatus($err));
            }
        }
    }

    return $vr_banners;
}

sub _set_vcards_validation_result {
    my ($self) = @_;
    unless ( Property->new($VCards::USE_JAVA_VCARDS_IN_SMART_PROPERTY_NAME)->get()
            && $self->operator_uid ) {
        return;
    }

    my $vcards = [map { $_->vcard } grep { $_->has_vcard && !$_->vcard->id } map { @{ $_->{banners} } } @{ $self->_data_to_apply }];
    return unless @$vcards;

    my $vcards_vr = JavaIntapi::ValidateVcards->new(items => [ map { $_->to_hash } @$vcards ],
            operator_uid => $self->operator_uid, client_id => $self->client_id)->call();

    my $generic_errors = $vcards_vr->get_generic_errors();
    foreach my $i (0..$#$vcards) {
        my $vr = $vcards_vr->get_nested_vr_by_index($i) // $vcards_vr->next();
        $vr->add_generic($generic_errors);
        $vcards->[$i]->{_vcard_validation_result} = $vr;
    }
}

sub _validate_keywords {
    my ($self, $adgroup, $keywords) = @_;

    # Разделим ключевые фразы на две группы: новые/изменившееся и не изменившееся
    my ($checked_keywords, $remaining_keywords) = part { !$_->id || $_->is_changed ? 0 : 1 } @$keywords;

    my $vr_keywords = validate_keywords_for_adgroup($checked_keywords // [], $remaining_keywords // [], $adgroup, $self->campaign, $self->client);
    $vr_keywords->process_objects_descriptions(Direct::Keywords->WEB_FIELD_NAMES);

    return $vr_keywords;
}

sub _validate_relevance_matches {
    my ($self, $adgroup, $relevance_matches) = @_;

    my $vr_relevance_matches = validate_relevance_matches_for_adgroup($relevance_matches, $adgroup, $self->campaign);
    $vr_relevance_matches->process_objects_descriptions(Direct::Bids::BidRelevanceMatch->WEB_FIELD_NAMES);

    return $vr_relevance_matches;
}

sub _validate_retargetings {
    my ($self, $adgroup, $retargetings) = @_;

    # Разделим ретаргетинг на две группы: новый/изменившийся и не изменившийся
    my ($checked_rets, $remaining_rets) = part { !$_->id || $_->is_changed ? 0 : 1 } @$retargetings;

    my $vr_retargetings = validate_retargetings_for_adgroup($checked_rets // [], $remaining_rets // [], $adgroup, $self->campaign);
    $vr_retargetings->process_objects_descriptions(Direct::Retargetings->WEB_FIELD_NAMES);

    return $vr_retargetings;
}

sub _validate_socdem_retargetings_for_cpm_campaign {
    my ($self, $user_rets) = @_;

    my $vr_retargetings = Direct::Retargetings::validate_socdem_retargetings_for_cpm_adgroup($user_rets, $self->campaign);
    $vr_retargetings->process_objects_descriptions(Direct::Retargetings->WEB_FIELD_NAMES);

    return $vr_retargetings;
}

sub _validate_target_interests {
    my ($self, $adgroup, $target_interests) = @_;

    # Разделим ретаргетинг на две группы: новый/изменившийся и не изменившийся
    my ($checked_target_interests, $remaining_target_interests) = part { !$_->id || $_->is_changed ? 0 : 1 } @$target_interests;

    my $vr_target_interests = validate_target_interests_for_adgroup($checked_target_interests // [], $remaining_target_interests // [], $adgroup, $self->campaign);
    $vr_target_interests->process_objects_descriptions(Direct::TargetInterests->WEB_FIELD_NAMES);

    return $vr_target_interests;
}

sub _validate_dynamic_conditions {
    my ($self, $adgroup, $dynamic_conditions) = @_;

    my $vr_dyn_conds = validate_dynamic_conditions_for_adgroup($dynamic_conditions, [], $self->campaign);
    $vr_dyn_conds->process_objects_descriptions(Direct::DynamicConditions->WEB_FIELD_NAMES);

    return $vr_dyn_conds;
}

sub _validate_performance_filters {
    my ($self, $adgroup, $perf_filters) = @_;

    my $vr_perf_filters = validate_performance_filters_for_adgroup($perf_filters, $self->campaign, $adgroup);
    $vr_perf_filters->process_objects_descriptions(Direct::PerformanceFilters->WEB_FIELD_NAMES);

    return $vr_perf_filters;
}

=head2 apply

Применение изменений в БД.

=cut

sub apply {
    my ($self) = @_;

    my $profile = Yandex::Trace::new_profile('smart:apply');

    return [] unless @{$self->_data_to_apply};
    croak "cannot apply invalid user data" unless $self->is_valid;
    croak "cannot apply user data to unknown campaign" unless $self->campaign_id;

    my %adgroups_to = (create => [], update => []);
    my %banners_to  = (create => [], update => [], delete => []);
    my (@vcard_banner_pairs, @sitelinks_set_banner_pairs);
    my $generated_videos = {};

    if (defined $self->_gen_video_resource_by_id && keys %{$self->_gen_video_resource_by_id}) {
        Direct::VideoAdditions->save_video_additions($self->operator_uid, $self->client_id,
            [values %{$self->_gen_video_resource_by_id}]);
        $generated_videos = { map {$_->id => $_} @{Direct::VideoAdditions->get_video_additions_from_bs(
            $self->client_id, [ values %{$self->_gen_video_resource_by_id} ])} };
    }

    for my $data_item (@{$self->_data_to_apply}) {
        $data_item->{adgroup}->minus_words(MinusWords::polish_minus_words_array($data_item->{adgroup}->minus_words))
            if $data_item->{adgroup}->has_minus_words;
        push @{$adgroups_to{!$data_item->{adgroup}->id ? 'create' : 'update'}}, $data_item->{adgroup};

        for my $banner (@{$data_item->{banners} // []}) {
            if ($banner->banner_type =~ /^text|mobile_content$/ &&
                $banner->has_creative && $banner->creative->has_creative_id &&
                $generated_videos->{$banner->creative->creative_id}) {
                my $creative_id = $banner->creative->creative_id;
                $banner->creative->creative($generated_videos->{$creative_id});
                croak "invalid layout_id for creative $creative_id" if validate_video_additions_layout_id($banner->banner_type => $banner->creative->creative);
            }
            push @{$banners_to{!$banner->id ? 'create' : 'update'}}, $banner;
            push @vcard_banner_pairs, [$banner->vcard, $banner] if $banner->has_vcard;
            push @sitelinks_set_banner_pairs, [$banner->sitelinks_set, $banner] if $banner->has_sitelinks_set;
        }
        for my $banner (@{$data_item->{banners_to_delete} // []}) {
            push @{$banners_to{delete}}, $banner;
        }
    }

    # Сохранение визиток
    if (@vcard_banner_pairs) {
        Direct::Model::VCard::Manager->new(items => [map { $_->[0] } @vcard_banner_pairs])->save($self->operator_uid);
        $_->[1]->vcard_id($_->[0]->id) for @vcard_banner_pairs;
    }

    # Сохранение сайтлинк-сетов
    if (@sitelinks_set_banner_pairs) {
        Direct::Model::SitelinksSet::Manager->new(items => [map { $_->[0] } @sitelinks_set_banner_pairs])->save();
        $_->[1]->sitelinks_set_id($_->[0]->id) for @sitelinks_set_banner_pairs;
    }

    # Для обновления групп нужен массив баннеров с определенным набором полей
    for my $adgroup (@{$adgroups_to{update}}) {
        $adgroup->banners([map { ## no critic (ProhibitComplexMappings)
            my $banner = $_;
            # TODO DIRECT-67003
            if (ref $banner eq 'Direct::Model::BannerImageAd') {
                $banner->new(
                    id => $banner->id, _flags => $banner->_flags, status_moderate => $banner->status_moderate,
                    $banner->has_image_ad ?
                        (image_ad => Direct::Model::Image->new(status_moderate => $banner->image_ad->status_moderate)) :
                        (creative => Direct::Model::BannerCreative->new(status_moderate => $banner->creative->status_moderate)),
                );
            } else {
                $banner->new(
                    id => $banner->id, _flags => $banner->_flags, status_moderate => $banner->status_moderate,
                );
            }
        } @{$self->_ex_banners_by_gid->{$adgroup->id}}]);
    }

    if ($self->is_text_campaign || $self->is_mobile_content_campaign) {
        my %keywords_to = (create => [], update => [], delete => []);
        {;
            for my $data_item (@{$self->_data_to_apply}) {
                my $keyword_to_update_by_id = {};
                for my $kw (@{$data_item->{keywords} // []}) {
                    if (!$kw->id) {
                        push @{$keywords_to{create}}, $kw;
                    } else {
                        push @{$keywords_to{update}}, $kw;
                        $keyword_to_update_by_id->{$kw->id} = 1;
                    }
                    $data_item->{adgroup}->has_show_conditions(1);
                }

                for my $kw (
                    grep { !$keyword_to_update_by_id->{$_->id} } @{$self->_ex_keywords_by_gid->{$data_item->{adgroup}->id} // []}
                ) {
                    # На удаляемых ключевых фразах должна быть группа
                    push @{$keywords_to{delete}}, $kw->clone(adgroup => $data_item->{adgroup});
                }
            }
        }

        my %relevance_matches_to = (create => [], update => [], delete => []);
        {;
            for my $data_item (@{$self->_data_to_apply}) {
                my $relevance_matches_to_update_by_id = {};

                for my $relevance_match (@{$data_item->{relevance_matches}}) {
                    if (!$relevance_match->id) {
                        push @{$relevance_matches_to{create}}, $relevance_match;
                    } else {
                        push @{$relevance_matches_to{update}}, $relevance_match;
                        $relevance_matches_to_update_by_id->{$relevance_match->id} = 1;
                    }
                    $data_item->{adgroup}->has_show_conditions(1);
                }

                for my $relevance_match (
                    grep { !$relevance_matches_to_update_by_id->{$_->id} } @{$self->_ex_relevance_matches_by_gid->{$data_item->{adgroup}->id} // []}
                ) {
                    # На удаляемых условиях беcфразного таргетинга должна быть группа
                    push @{$relevance_matches_to{delete}}, $relevance_match->clone(adgroup => $data_item->{adgroup});
                }
            }
        }

        my %retargetings_to = (create => [], update => [], delete => []);
        {;
            for my $data_item (@{$self->_data_to_apply}) {
                my $retargeting_to_update_by_id = {};

                for my $ret (@{$data_item->{retargetings} // []}) {
                    if (!$ret->id) {
                        push @{$retargetings_to{create}}, $ret;
                    } else {
                        push @{$retargetings_to{update}}, $ret;
                        $retargeting_to_update_by_id->{$ret->id} = 1;
                    }
                    $data_item->{adgroup}->has_show_conditions(1);
                }

                for my $ret (
                    grep { !$retargeting_to_update_by_id->{$_->id} } @{$self->_ex_retargetings_by_gid->{$data_item->{adgroup}->id} // []}
                ) {
                    # На удаляемых ретаргетингах должна быть группа
                    push @{$retargetings_to{delete}}, $ret->clone(adgroup => $data_item->{adgroup});
                }
            }
        }

        my %target_interests_to = (create => [], update => [], delete => []);
        {;
            for my $data_item (@{$self->_data_to_apply}) {
                my $target_interest_to_update_by_id = {};

                for my $target_interest (@{$data_item->{target_interests} // []}) {
                    if (!$target_interest->id) {
                        push @{$target_interests_to{create}}, $target_interest;
                    } else {
                        push @{$target_interests_to{update}}, $target_interest;
                        $target_interest_to_update_by_id->{$target_interest->id} = 1;
                    }
                    $data_item->{adgroup}->has_show_conditions(1);
                }

                for my $target_interest (
                    grep { !$target_interest_to_update_by_id->{$_->id} } @{$self->_ex_target_interests_by_gid->{$data_item->{adgroup}->id} // []}
                ) {
                    # На удаляемых таргетингах по интересам должна быть группа
                    push @{$target_interests_to{delete}}, $target_interest->clone(adgroup => $data_item->{adgroup});
                }
            }
        }

        if ($self->is_text_campaign) {
            # Сохранение текстовых групп
            do_in_transaction {
                Direct::AdGroups2::Text->new($adgroups_to{create})->create($self->chief_uid);
                Direct::AdGroups2::Text->new($adgroups_to{update})->update($self->chief_uid);
            };
        }

        if ($self->is_mobile_content_campaign) {
            # Сохранение РМП групп
            do_in_transaction {
                Direct::AdGroups2::MobileContent->new($adgroups_to{create})->create($self->chief_uid);
                Direct::AdGroups2::MobileContent->new($adgroups_to{update})->update($self->chief_uid);
            };
        }

        do_in_transaction {
            # Сохранение беcфразного таргетинга
            $_->adgroup_id($_->adgroup->id) for @{$relevance_matches_to{create}};
            Direct::Bids::BidRelevanceMatch->new($relevance_matches_to{delete})->delete();
            Direct::Bids::BidRelevanceMatch->new($relevance_matches_to{create})->create();
            Direct::Bids::BidRelevanceMatch->new($relevance_matches_to{update})->update();
        };

        do_in_transaction {
            # Сохранение ретаргетинга
            $_->adgroup_id($_->adgroup->id) for @{$retargetings_to{create}};
            Direct::Retargetings->new($retargetings_to{delete})->delete();
            Direct::Retargetings->new($retargetings_to{create})->create();
            Direct::Retargetings->new($retargetings_to{update})->update();
        };

        do_in_transaction {
            # Сохранение интересов
            $_->adgroup_id($_->adgroup->id) for @{$target_interests_to{create}};
            Direct::TargetInterests->new($target_interests_to{delete})->delete();
            Direct::TargetInterests->new($target_interests_to{create})->create();
            Direct::TargetInterests->new($target_interests_to{update})->update();
        };
        $_->adgroup_id($_->adgroup->id) for @{$banners_to{create}};

        do_in_transaction {
            # Сохранение ключевых фраз
            $_->adgroup_id($_->adgroup->id) for @{$keywords_to{create}};
            Direct::Keywords->new($keywords_to{delete})->delete();
            Direct::Keywords->new($keywords_to{create})->create();
            Direct::Keywords->new($keywords_to{update})->update();
        };

        # Копирование CTR
        for my $data_item (@{$self->_data_to_apply}) {
            my @banners_to = @{$data_item->{banners} // []};
            if (my @keywords_to = grep { $_->has_ctr_source && defined $_->ctr_source } @{$data_item->{keywords} // []}) {
                $_->do_copy_ctr({keywords => {map { $_->id => $_->ctr_source } @keywords_to}}) for @banners_to;
            }
        }

        if ($self->is_text_campaign) {
            # Сохранение текстовых и графических баннеров
            my (%text_banners_to, %imagead_banners_to, %cpc_video_banners_to);
            for my $mode (qw/create update/) {
                for my $banner (@{$banners_to{$mode}}) {
                    if (ref $banner eq 'Direct::Model::BannerText') {
                        push @{$text_banners_to{$mode}}, $banner;
                    }
                    elsif (ref $banner eq 'Direct::Model::BannerImageAd') {
                        push @{$imagead_banners_to{$mode}}, $banner;
                    }
                    elsif (ref $banner eq 'Direct::Model::BannerCpcVideo') {
                        push @{$cpc_video_banners_to{$mode}}, $banner;
                    }
                    else {
                        warn "Attempted to create text group with banner of unexpected type '@{[ref $banner]}'";
                    }
                }
            }
            do_in_transaction {
                Direct::Banners::Text->new($text_banners_to{create}//[])->create($self->chief_uid);
                Direct::Banners::Text->new($text_banners_to{update}//[])->update($self->chief_uid);
                Direct::Banners::ImageAd->new($imagead_banners_to{create}//[])->create($self->chief_uid);
                Direct::Banners::ImageAd->new($imagead_banners_to{update}//[])->update($self->chief_uid);
                Direct::Banners::CpcVideo->new($cpc_video_banners_to{create}//[])->create($self->chief_uid);
                Direct::Banners::CpcVideo->new($cpc_video_banners_to{update}//[])->update($self->chief_uid);
            };
        }

        if ($self->is_mobile_content_campaign) {
            # Сохранение РМП баннеров
            my (%mobile_banners_to, %imagead_banners_to, %cpc_video_banners_to);
            for my $mode (qw/create update/) {
                for my $banner (@{$banners_to{$mode}}) {
                    if (ref $banner eq 'Direct::Model::BannerMobileContent') {
                        push @{$mobile_banners_to{$mode}}, $banner;
                    }
                    elsif (ref $banner eq 'Direct::Model::BannerImageAd') {
                        push @{$imagead_banners_to{$mode}}, $banner;
                    }
                    elsif (ref $banner eq 'Direct::Model::BannerCpcVideo') {
                        push @{$cpc_video_banners_to{$mode}}, $banner;
                    }
                }
            }
            do_in_transaction {
                Direct::Banners::MobileContent->new($mobile_banners_to{create}//[])->create($self->chief_uid);
                Direct::Banners::MobileContent->new($mobile_banners_to{update}//[])->update($self->chief_uid);
                Direct::Banners::ImageAd->new($imagead_banners_to{create}//[])->create($self->chief_uid);
                Direct::Banners::ImageAd->new($imagead_banners_to{update}//[])->update($self->chief_uid);
                Direct::Banners::CpcVideo->new($cpc_video_banners_to{create}//[])->create($self->chief_uid);
                Direct::Banners::CpcVideo->new($cpc_video_banners_to{update}//[])->update($self->chief_uid);
            };
        }

        # Для совместимости со старым кодом, заполним на новых группах устаревшее поле `bid`
        if (my @created_banners = @{$banners_to{create}}) {
            my %gid2bid = map { $_->adgroup_id => {bid => $_->id, LastChange => 'LastChange'} } @created_banners;
            do_mass_update_sql(PPC(pid => [keys %gid2bid]), 'phrases', 'pid',
                \%gid2bid,
                where => {bid__is_null => 1},
                byfield_options => {LastChange => {dont_quote_value => 1}},
            );

            $self->new_banners(\@created_banners);
        }
    } elsif ($self->is_dynamic_campaign) {
        my %dyn_conds_to = (create => [], update => [], delete => []);

        for my $data_item (@{$self->_data_to_apply}) {
            my $dyn_cond_to_update_by_id = {};

            for my $dyn_cond (@{$data_item->{dynamic_conditions} // []}) {
                if (!$dyn_cond->id) {
                    push @{$dyn_conds_to{create}}, $dyn_cond;
                } else {
                    push @{$dyn_conds_to{update}}, $dyn_cond;
                    $dyn_cond_to_update_by_id->{$dyn_cond->id} = 1;
                }
            }

            for my $dyn_cond (
                grep { !$dyn_cond_to_update_by_id->{$_->id} } @{$self->_ex_dyn_conds_by_gid->{$data_item->{adgroup}->id} // []}
            ) {
                # На удаляемых условиях нацеливания должна быть группа
                push @{$dyn_conds_to{delete}}, $dyn_cond->clone(adgroup => $data_item->{adgroup});
            }
        }

        do_in_transaction {
            # Сохранение динамических групп
            Direct::AdGroups2::Dynamic->new($adgroups_to{create})->create($self->chief_uid);
            Direct::AdGroups2::Dynamic->new($adgroups_to{update})->update($self->chief_uid);
        };

        do_in_transaction {
            # Сохранение условий нацеливания
            $_->adgroup_id($_->adgroup->id) for @{$dyn_conds_to{create}};
            Direct::DynamicConditions->new($dyn_conds_to{delete})->delete();
            Direct::DynamicConditions->new($dyn_conds_to{create})->create();
            Direct::DynamicConditions->new($dyn_conds_to{update})->update();

            # Т.к. теперь на соответствующих группах появились условия нацеливания, отразим это
            $_->adgroup->has_show_conditions(1) for @{$dyn_conds_to{create}};
        };

        do_in_transaction {
            # Сохранение динамических баннеров
            $_->adgroup_id($_->adgroup->id) for @{$banners_to{create}};
            Direct::Banners::Dynamic->new($banners_to{create})->create($self->chief_uid);
            Direct::Banners::Dynamic->new($banners_to{update})->update($self->chief_uid);
        };
    } elsif ($self->is_performance_campaign) {
        my %perf_filters_to = (create => [], update => [], delete => []);

        for my $data_item (@{$self->_data_to_apply}) {
            my $perf_filter_to_update_by_id = {};

            for my $perf_filter (@{$data_item->{performance_filters} // []}) {
                if (!$perf_filter->id) {
                    push @{$perf_filters_to{create}}, $perf_filter;
                } else {
                    push @{$perf_filters_to{update}}, $perf_filter;
                    $perf_filter_to_update_by_id->{$perf_filter->id} = 1;
                }
            }

            for my $perf_filter (
                grep { !$perf_filter_to_update_by_id->{$_->id} } @{$self->_ex_perf_filters_by_gid->{$data_item->{adgroup}->id} // []}
            ) {
                # На удаляемых фильтрах должна быть группа
                push @{$perf_filters_to{delete}}, $perf_filter->clone(adgroup => $data_item->{adgroup});
            }
        }

        do_in_transaction {
            # Сохранение перфоманс групп
            Direct::AdGroups2::Performance->new($adgroups_to{create})->create($self->chief_uid) if @{$adgroups_to{create}};
            Direct::AdGroups2::Performance->new($adgroups_to{update})->update($self->chief_uid) if @{$adgroups_to{update}};
        };

        do_in_transaction {
            # Сохранение фильтров
            $_->adgroup_id($_->adgroup->id) for @{$perf_filters_to{create}};
            Direct::PerformanceFilters->new($perf_filters_to{delete})->delete() if @{$perf_filters_to{delete}};
            Direct::PerformanceFilters->new($perf_filters_to{create})->create() if @{$perf_filters_to{create}};
            Direct::PerformanceFilters->new($perf_filters_to{update})->update() if @{$perf_filters_to{update}};
        };

        do_in_transaction {
            # Т.к. теперь на соответствующих группах появились условия нацеливания, отразим это
            $_->adgroup->has_show_conditions(1) for @{$perf_filters_to{create}};
            # Сохранение перфоманс баннеров
            # (!) Порядок операций важен
            $_->adgroup_id($_->adgroup->id) for @{$banners_to{create}};
            Direct::Banners::Performance->new($banners_to{delete})->delete($self->chief_uid) if @{$banners_to{delete}};
            Direct::Banners::Performance->new($banners_to{update})->update($self->chief_uid) if @{$banners_to{update}};
            Direct::Banners::Performance->new($banners_to{create})->create($self->chief_uid) if @{$banners_to{create}};
        };
    } elsif ($self->is_mcbanner_campaign) {
        # про ключевики - копипастненько с text/mobile_content
        my %keywords_to = (create => [], update => [], delete => []);
        {;
            for my $data_item (@{$self->_data_to_apply}) {
                my $keyword_to_update_by_id = {};

                for my $kw (@{$data_item->{keywords} // []}) {
                    if (!$kw->id) {
                        push @{$keywords_to{create}}, $kw;
                    } else {
                        push @{$keywords_to{update}}, $kw;
                        $keyword_to_update_by_id->{$kw->id} = 1;
                    }
                }

                for my $kw (
                    grep { !$keyword_to_update_by_id->{$_->id} } @{$self->_ex_keywords_by_gid->{$data_item->{adgroup}->id} // []}
                ) {
                    # На удаляемых ключевых фразах должна быть группа
                    push @{$keywords_to{delete}}, $kw->clone(adgroup => $data_item->{adgroup});
                }
            }
        }
        # Сохранение текстовых групп
        do_in_transaction {
            Direct::AdGroups2::Mcbanner->new($adgroups_to{create})->create($self->chief_uid);
            Direct::AdGroups2::Mcbanner->new($adgroups_to{update})->update($self->chief_uid);
        };

        $_->adgroup_id($_->adgroup->id) for @{$banners_to{create}};

        do_in_transaction {
            # Сохранение ключевых фраз
            $_->adgroup_id($_->adgroup->id) for @{$keywords_to{create}};
            Direct::Keywords->new($keywords_to{delete})->delete();
            Direct::Keywords->new($keywords_to{create})->create();
            Direct::Keywords->new($keywords_to{update})->update();
        };

        # TODO DIRECT-67003 нужно ли? видимо да
        # Копирование CTR
        for my $data_item (@{$self->_data_to_apply}) {
            my @banners_to = @{$data_item->{banners} // []};
            if (my @keywords_to = grep { $_->has_ctr_source && defined $_->ctr_source } @{$data_item->{keywords} // []}) {
                $_->do_copy_ctr({keywords => {map { $_->id => $_->ctr_source } @keywords_to}}) for @banners_to;
            }
        }

        # Сохранение баннеров
        do_in_transaction {
            Direct::Banners::Mcbanner->new($banners_to{create}//[])->create($self->chief_uid);
            Direct::Banners::Mcbanner->new($banners_to{update}//[])->update($self->chief_uid);
        };

        # TODO DIRECT-67003 тут еще НЕ скопипащен кусок про заполнение bid во phrase. может оно и не надо
    } elsif ($self->is_cpm_banner_campaign || $self->is_cpm_deals_campaign) {
        # Сохранение соцдема
        {;
            my $it = each_array(@{$self->_data_to_apply}, @{$self->_user_adgroups});
            while (my ($data_item, $user_adgroup ) = $it->()) {
                my $adgroup = $data_item->{adgroup};
                if (($adgroup->adgroup_type =~ /cpm_(banner|video)/)
                    && (any {$_->{type} && $_->{type} eq 'interests'} @{$user_adgroup->{retargetings}})) {

                    # Сохраняем соцдем-ретаргетинги через ручку Int API
                    Direct::Retargetings::save_socdem_retargetings_for_cpm_adgroup(
                        $user_adgroup->{retargetings}, $data_item->{retargetings}, $self->campaign
                    );
                }
            }
        }

        # про ключевики - скопировано с text/mobile_content
        my %keywords_to = (create => [], update => [], delete => []);
        {;
            for my $data_item (@{$self->_data_to_apply}) {
                my $keyword_to_update_by_id = {};

                for my $kw (@{$data_item->{keywords} // []}) {
                    if (!$kw->id) {
                        push @{$keywords_to{create}}, $kw;
                    } else {
                        push @{$keywords_to{update}}, $kw;
                        $keyword_to_update_by_id->{$kw->id} = 1;
                    }
                }

                for my $kw (
                    grep { !$keyword_to_update_by_id->{$_->id} } @{$self->_ex_keywords_by_gid->{$data_item->{adgroup}->id} // []}
                ) {
                    # На удаляемых ключевых фразах должна быть группа
                    push @{$keywords_to{delete}}, $kw->clone(adgroup => $data_item->{adgroup});
                }
            }
        }

        my %retargetings_to = (create => [], update => [], delete => []);
        {;
            for my $data_item (@{$self->_data_to_apply}) {
                my $retargeting_to_update_by_id = {};

                for my $ret (@{$data_item->{retargetings} // []}) {
                    if (!$ret->id) {
                        push @{$retargetings_to{create}}, $ret;
                    } else {
                        push @{$retargetings_to{update}}, $ret;
                        $retargeting_to_update_by_id->{$ret->id} = 1;
                    }
                    $data_item->{adgroup}->has_show_conditions(1);
                }

                for my $ret (
                    grep { !$retargeting_to_update_by_id->{$_->id} } @{$self->_ex_retargetings_by_gid->{$data_item->{adgroup}->id} // []}
                ) {
                    # На удаляемых ретаргетингах должна быть группа
                    push @{$retargetings_to{delete}}, $ret->clone(adgroup => $data_item->{adgroup});
                }
            }
        }

        my %groups_by_type;
        for my $action (keys %adgroups_to) {
            for my $group (@{$adgroups_to{$action}}) {
                push @{$groups_by_type{$action}{$group->meta->name}}, $group;
            }
        }

        # Сохранение групп
        do_in_transaction {
            Direct::AdGroups2::CpmBanner->new($groups_by_type{create}{'Direct::Model::AdGroupCpmBanner'}//[])->create($self->chief_uid);
            Direct::AdGroups2::CpmBanner->new($groups_by_type{update}{'Direct::Model::AdGroupCpmBanner'}//[])->update($self->chief_uid);
        };
        
        do_in_transaction {
            Direct::AdGroups2::CpmVideo->new($groups_by_type{create}{'Direct::Model::AdGroupCpmVideo'}//[])->create($self->chief_uid);
            Direct::AdGroups2::CpmVideo->new($groups_by_type{update}{'Direct::Model::AdGroupCpmVideo'}//[])->update($self->chief_uid);
        };

        $_->adgroup_id($_->adgroup->id) for @{$banners_to{create}};

        do_in_transaction {
            # Сохранение ключевых фраз
            $_->adgroup_id($_->adgroup->id) for @{$keywords_to{create}};
            Direct::Keywords->new($keywords_to{delete})->delete();
            Direct::Keywords->new($keywords_to{create})->create();
            Direct::Keywords->new($keywords_to{update})->update();
        };

        # Копирование CTR
        for my $data_item (@{$self->_data_to_apply}) {
            my @banners_to = @{$data_item->{banners} // []};
            if (my @keywords_to = grep { $_->has_ctr_source && defined $_->ctr_source } @{$data_item->{keywords} // []}) {
                $_->do_copy_ctr({keywords => {map { $_->id => $_->ctr_source } @keywords_to}}) for @banners_to;
            }
        }

        do_in_transaction {
            # Сохранение ретаргетинга
            $_->adgroup_id($_->adgroup->id) for @{$retargetings_to{create}};
            Direct::Retargetings->new($retargetings_to{delete})->delete();
            Direct::Retargetings->new($retargetings_to{create})->create();
            Direct::Retargetings->new($retargetings_to{update})->update();
        };

        # Сохранение баннеров
        do_in_transaction {
            Direct::Banners::CpmBanner->new($banners_to{create}//[])->create($self->chief_uid);
            Direct::Banners::CpmBanner->new($banners_to{update}//[])->update($self->chief_uid);
        };
    }

    return $self->_data_to_apply;
}

=head2 get_errors_response

Вернуть результат validation result в формате принимаемы фронтом

=cut

sub get_errors_response {
    my $self = shift;

    my %response;
    if (@{$self->errors}) {
        $response{generic_errors} = [map { {text => $_} } @{$self->errors}];
    } else {
        my $vr = $self->validation_result;
        $response{groups} = Direct::ValidationResult::convert_vr_for_frontend($vr, groups => { map { $_ => 1 } qw/groups banners performance_filters retargetings pixels/ });
    }
    return \%response;
}

=head2 _load_video_resources

Инициализация _ex_video_resource_by_id и _gen_video_resource_by_id

=cut

sub _load_video_resources
{
    my ($self, $user_adgroups) = @_;
    my $chief_uid = $self->chief_uid;
    my $client_id = $self->client_id;

    if (my @creative_ids = map { $_->{video_resources}->{id} // () } map { @{$_->{banners} // []} } @$user_adgroups) {
        my $creatives = Direct::VideoAdditions->get_by(creative_id => \@creative_ids, $chief_uid);
        $self->_ex_video_resource_by_id($creatives->items_by('id'));

        my @unknown_creatives = grep {!$self->_ex_video_resource_by_id->{$_}} @creative_ids;
        my $bs_creatives = eval {Direct::VideoAdditions->recieve_video_additions($client_id, \@unknown_creatives)->{recieved};} || [];
        if ($@) {
            print STDERR "Failed to recieve video additions:$@ \n";

        }
        $self->_gen_video_resource_by_id({map {$_->{creative_id} => $_} @{$bs_creatives}});
    }
    
    my @ex_adgroup_ids = grep { $_ } map { $_->{adgroup_id} } @$user_adgroups;

    $self->_ex_banner_creatives_by_id(
        Direct::BannersCreatives->get_by(client_id => $client_id, filter => { adgroup_id => \@ex_adgroup_ids, campaign_id => $self->campaign_id })->items_by('banner_id'));
}

__PACKAGE__->meta->make_immutable;

1;
