package Direct::AdditionsItemDisclaimers;

use Direct::Modern;

use Mouse;

use Settings;

use Direct::Model::AdditionsItemDisclaimer::Manager;

use Yandex::DBTools;




has 'items' => (is => 'ro', isa => 'ArrayRef[Direct::Model::AdditionsItemDisclaimer]');


=head2 save

Сохранение списка дисклеймеров

    my $disclaimer = Direct::Model::AdditionsItemDisclaimer->new(client_id => 123, disclaimer_text => "text")
    Direct::AdditionsItemisclaimers->new(items => [$disclaimer])->save();

=cut

sub save {
    my ($self) = @_;

    my @to_save = grep {!$_->has_id || !$_->id} @{$self->items};
    return if !@to_save;

    Direct::Model::AdditionsItemDisclaimer::Manager->new(items => \@to_save)->create();
    return;
}



=head2 get_by

По заданному критерию возвращает список дисклеймеров Direct::Model::AdditionsItemDisclaimer

    my $disclaimers = Direct::AdditionsItemDisclaimer::get_by(%opts);

где C<%opts>:

    id - искать по точному совпадению с указанным иденитификатором(ами)
    client_id - вернуть все уточнения по клиенту, включая не привязанные к баннерам
    campaign_id - вернуть все уточнения по кампаниям
    adgroup_id - вернуть все уточнения по группе(ам)
    banner_id - вернуть все уточнения по баннер(у|ам)
    shard => если доступен шард, например при выгрузке уточнений для транспорта модерации
    get_banner_id => 0|1 - возвращать banner_id в Direct::Model::AdditionsItemDisclaimer, все дополнения должы быть привязаны к баннерам
    except_client_ids => [] - не возвращать дополнения принадлежащие указанным ClientID

    limit, offset - параметры для пагинации
    sort - [{column_name => 'asc'|'desc'}, {column_name2  => 'asc'}, ...] - сортировка по списку полей

=cut

sub get_by {
    my ($class, %opt) = @_;

    state $_get_by_valid_opt = +{ map {$_ => 1} qw/
        adgroup_id
        banner_id
        campaign_id
        client_id
        get_banner_id
        id
        limit
        offset
        shard
        sort
        except_client_ids
    /};

    croak "get_by() opt is not valid" if grep {! $_get_by_valid_opt->{$_}} keys %opt;

    my $shard;
    my %where;

    for my $search_by_field (grep {$opt{$_}} qw/id client_id/) {
        my ($db_field) = Direct::Model::AdditionsItemDisclaimer->get_db_columns_list('additions_item_disclaimers', [$search_by_field]);
        $where{$db_field} = $opt{$search_by_field};
    }
    $where{bid} = $opt{banner_id} if $opt{banner_id};
    $where{"b.cid"} = $opt{campaign_id} if $opt{campaign_id};
    $where{"b.pid"} = $opt{adgroup_id} if $opt{adgroup_id};

    if ($opt{except_client_ids}) {
        my ($db_field) = Direct::Model::AdditionsItemDisclaimer->get_db_columns_list('additions_item_disclaimers', ['client_id']);
        $where{$db_field.'__not_in'} = $opt{except_client_ids};
    }

    if ($opt{shard}) {
        $shard = PPC(shard => $opt{shard});
    } elsif ($opt{client_id}) {
        $shard = PPC(ClientID => $opt{client_id});
    } elsif ($opt{campaign_id}) {
        $shard = PPC(cid => $opt{campaign_id});
    } elsif ($opt{adgroup_id}) {
        $shard = PPC(pid => $opt{adgroup_id});
    } elsif ($opt{banner_id}) {
        $shard = PPC(bid => $opt{banner_id});
    } else {
        croak "client_id/campaign_id/banner_id/shard required";
    }

    my @fields = map {"additions_item_disclaimers.$_"} Direct::Model::AdditionsItemDisclaimer->get_db_columns_list('additions_item_disclaimers');
    push @fields, 'banners_additions.bid as banner_id' if $opt{get_banner_id};
    my $fields = join(", ", @fields);

    my $join_sql = '';
    if ($opt{campaign_id} || $opt{adgroup_id}) {
        $join_sql = 'join banners_additions using(additions_item_id)
                     join banners b using(bid)
                    ';
    } elsif ($opt{get_banner_id} || $opt{banner_id}) {
        $join_sql = 'join banners_additions using(additions_item_id)';
    }

    my $limit_sql = '';
    if ($opt{limit}) {
        $limit_sql = " limit " . int($opt{limit}) . " ";
        $limit_sql .= " offset " . int($opt{offset}) . " " if $opt{offset};
    }

    my @order_clauses;
    if ($opt{sort}) {
        for my $sort_part (@{$opt{sort}}) {
            my ($field, $direction) = (%$sort_part); # (key, value)
            my ($db_field) = Direct::Model::AdditionsItemDisclaimer->get_db_columns_list('additions_item_disclaimers', [$field]);
            push @order_clauses, sql_quote_identifier($db_field) . " " . ($direction eq 'asc' ? 'asc' : 'desc');
        }
    }

    # при запросе по баннерам сортируем в правильной последовательности
    if ($opt{get_banner_id} || $opt{banner_id}) {
        push @order_clauses, 'banners_additions.bid', 'banners_additions.sequence_num asc';
    }

    my $sort_sql = @order_clauses ? "order by " . join(",", @order_clauses) : '';


    my $rows = get_all_sql($shard, [
        "select $fields
         from additions_item_disclaimers
         $join_sql
        ",
        where => \%where,
        $sort_sql,
        $limit_sql,
    ]);

    my $items = Direct::Model::AdditionsItemDisclaimer->from_db_hash_multi($rows);
   
    my $result = $class->new(items => $items);

    return $result;
}

=head2 items_by

    Вернуть сгруппированный по ключу хеш
    при группировке по banner_id:
        - в исходном объекте должен быть banner_id, например полученный через get_by(... get_banner_id => 1 ...)
        - не привязанные баннеры не возвращаются

=cut

sub items_by {
    my ($self, $key) = @_;

    $key //= 'banner_id';
    croak "by `banner_id, client_id` only supported" unless $key =~ /^(?:banner_id|client_id)$/;

    my %result;
    if ($key eq 'banner_id') {
        for my $item (@{$self->items}) {
            next unless $item->banner_id;
            push @{$result{$item->banner_id}}, $item;
        }
    } elsif ($key eq 'client_id') {
        for my $item (@{$self->items}) {
            push @{$result{$item->client_id}}, $item;
        }
    }

    return \%result;
}

1;
