package Direct::AdditionsItemExperiments;

use Direct::Modern;
use Mouse;
use Settings;
use Direct::Model::AdditionsItemExperiment::Manager;

has 'items' => (is => 'ro', isa => 'ArrayRef[Direct::Model::AdditionsItemExperiment]');


=head2 save

Сохранение списка экспериментов

    my $expriment = Direct::Model::AdditionsItemExperiment->new(client_id => 123, experiment_json => "{'param1':123,'pamam2':456}")
    Direct::AdditionsItemExperiments->new(items => [$experiment])->save();

=cut

sub save {
    my ($self) = @_;

    my @to_save = grep {!$_->has_id || !$_->id} @{$self->items};
    return if !@to_save;

    Direct::Model::AdditionsItemExperiment::Manager->new(items => \@to_save)->create();
    return;
}

1;
