package Direct::AgencyOptions;

use Mouse;

use Direct::Modern;

use Settings;

use Direct::Model::AgencyOptions;
use Direct::Model::AgencyOptions::Manager;

use Yandex::DBTools;

has 'items' => (is => 'ro', isa => 'ArrayRef[Direct::Model::AgencyOptions]');

around BUILDARGS => sub {
        my ($orig, $class) = (shift, shift);
        $class->$orig(@_ == 1 ? (items => $_[0]) : @_)
    };


=head2 manager
=cut
sub manager {
    my ($self) = @_;
    return Direct::Model::AgencyOptions::Manager->new(items => $self->items);
}


=head2 get_item($class, $agency_id)

    Возвращает объект Direct::Model::AgencyOptions для агентства $agency_id, или undef

=cut

sub get_item {
    my ($class, $agency_id) = @_;

    my $row = get_one_line_sql(PPC(ClientID => $agency_id), [
        SELECT => Direct::Model::AgencyOptions->get_db_columns('agency_options'),
        FROM => 'agency_options',
        WHERE => {
            ClientID => $agency_id,
        }
    ]);

    unless ($row) {
        return undef;
    }
    return Direct::Model::AgencyOptions->from_db_hash($row, \{});
}


=head2 prepare_update($self)

    Бизнес логика при обновлении объектов

=cut

sub prepare_update {
    my ($self) = @_;

    for my $agency_options (@{$self->items}) {
        if (!$agency_options->allow_clients_without_wallet()) {
            $agency_options->default_clients_with_wallet(1);
        }
    }

    return;
}

=head2 update($self)

    Обновить объекты $self->items() в БД

=cut

sub update {
    my ($self) = @_;

    $self->prepare_update();
    $self->manager->update();

    return;
}

1;
