package Direct::Avatars;

=head1 DESCRIPTION

Работа с разными типами аватарницы

=cut

use Direct::Modern;

#use Yandex::Avatars;
use Yandex::Avatars::MDS;
use Yandex::URL qw/get_host/;

use Settings;


use Mouse;


our %DEFAULT_PUT_RPS = (
    direct => 10,
    mcb => 10,
);


has namespace => (is => 'ro', isa => 'Str', required => 1);
has put_rps => (
    is => 'rw',
    isa => 'Int',
    default => sub {$DEFAULT_PUT_RPS{shift()->namespace}},
    lazy => 1,
);



sub _get_put_method {
    my $self = shift;

    state $put_method_by_namespace = {
        mcb                 => '_put_mds',
        direct              => '_put_mds',
#        'direct-picture'    => '_put_mds',
    };

    my $namespace = $self->namespace;
    my $method = $put_method_by_namespace->{$namespace};
    croak "Unsupported namespace <$namespace>"  if !$method;
    return $method;
}


sub _put_mds {
    my $self = shift;
    my ($name, $data, %opt) = @_;

    my $avatars = Yandex::Avatars::MDS->new(namespace => $self->namespace, put_rps => $self->put_rps);
    my $res = $avatars->put($name, $data, %opt);
    $res->{avatars_host} = get_host($avatars->get_host);
    return $res;
}



=head2 put

Запись в ававтарницу

=cut

sub put {
    my $self = shift;
    my ($name, $data, %opt) = @_;

    my $put_method = $self->_get_put_method();
    my $result = $self->$put_method($name, $data, %opt);

    $result->{image_hash} = $name;
    return $result;
}

=head2 put_multi


=cut

sub put_multi {
    my $self = shift;
    my ($task_info, %opt) = @_;

    my $avatars = Yandex::Avatars::MDS->new(namespace => $self->namespace, put_rps => $self->put_rps);
    my $res = $avatars->put_multi($task_info, %opt);

    my $host = get_host($avatars->get_host);
    $_->{avatars_host} = $host  for values %$res;

    return $res;
}



=head2 get

Получение данных из аватарницы

=cut

sub get {
    my $self = shift;
    my ($image_params, $format) = @_;


    $format ||= 'orig';

    my $image;

    my $mds_group_id = $image_params->{mds_group_id}//'0'; # DIRECT-108344
    croak 'Avatars host is not defined for image'  unless $image_params->{avatars_host};

    my $avatars = Yandex::Avatars::MDS->new(namespace => $self->namespace, get_host => $image_params->{avatars_host});
    $image = $avatars->get($mds_group_id, $image_params->{image_hash}, $format);

    return $image;
}


=head2 get_avatars_link

Получить ссылку на картинку
В качестве $image можно передать возврат put или запись из базы

=cut

sub get_avatars_link {
    my $self = shift;
    my ($image, $format) = @_;
    $format ||= 'orig';

    my $hash = $image->{image_hash} || $image->{hash};
    croak 'Image hash is not defined'  if !$hash;
    my $mds_group_id = $image->{mds_group_id} || $image->{'group-id'};
    $mds_group_id //= '0'; # DIRECT-108344

    my $url;
    croak 'Avatars host is not defined for image'  if !$image->{avatars_host};
    my $avatars = Yandex::Avatars::MDS->new(namespace => $self->namespace, get_host => $image->{avatars_host});
    $url = $avatars->avatars_url('get', short => 1) . "/$mds_group_id/$hash/$format";

    return $url;
}



__PACKAGE__->meta->make_immutable();
1;

