package Direct::BannerImages;

use Direct::Modern;

use base qw/Exporter/;
our @EXPORT_OK = qw/
    link_unlink_images_to_banners
/;

=head2 link_unlink_images_to_banners($banners)

=cut

sub link_unlink_images_to_banners {
    my ($banners) = @_;

    for my $banner (@$banners) {
        next unless $banner->has_image_hash;

        # Если задан $banner->image_hash, то должен существовать объект $banner->image с таким же image_hash
        croak "banner has image_hash but not equal with banner->image->hash" if
            defined $banner->image_hash &&
            (!$banner->has_image || !$banner->image->has_hash || $banner->image->hash ne $banner->image_hash);

        if (defined $banner->image_hash) {
            # Баннер является черновиком
            if ($banner->status_moderate eq 'New') {
                $banner->image->status_moderate('New');
                if ($banner->does_role('Update') && $banner->has_old && $banner->old->has_image && $banner->old->image->status_moderate ne 'New') {
                    # Если картинка не была черновиком, то нужно удалить её из модерации
                    $banner->do_delete_image_from_moderation(1);
                }
                next;
            }

            # Привязали новую картинку или (пере)отправили баннер на модерацию
            $banner->image->status_moderate('Ready') if $banner->is_image_hash_changed || $banner->status_moderate eq 'Ready';
        } else {
            # Картинку нужно убрать из модерации (если ее удалили)
            $banner->do_delete_image_from_moderation(1) if $banner->is_image_hash_changed;
        }

        $banner->status_bs_synced('No') if $banner->is_image_hash_changed;
    }

    return $banners;
}

1;
