package Direct::Banners::AdditionalHrefs;

use Mouse;

use Direct::Modern;

use Settings;

use Direct::Model::Banner::AdditionalHref;

use Yandex::DBTools;
use Yandex::DBShards;

has 'items' => (is => 'ro', isa => 'ArrayRef[Direct::Model::Banner::AdditionalHref]');

around BUILDARGS => sub { my ($orig, $class) = (shift, shift); $class->$orig(@_ == 1 ? (items => $_[0]) : @_) };


=head2 get_by($key, $vals)

По заданному критерию возвращает instance с выбранными измерителями баннера.

Параметры:
    $key  -> по какому ключу выбирать: banner_id
    $vals -> (Int|ArrayRef[Int]); список идентификаторов

=cut

sub get_by {
    my ($class, $key, $vals) = @_;

    croak "only `banner_id` key is supported" unless $key =~ /^(?:banner)_id$/;

    $vals = [$vals // ()] if ref($vals) ne 'ARRAY';
    return $class->new(items => []) if !@$vals;

    my $hrefs = get_all_sql(PPC(bid => $vals), [
        "SELECT href_id, bid, `index`, href FROM banner_additional_hrefs",
        where => {
            'bid' => SHARD_IDS,
        },
       "ORDER BY bid, `index`"
    ]);

    my $_cache;
    my $result = [map {Direct::Model::Banner::AdditionalHref->from_db_hash($_, \$_cache)} @$hrefs];
    return $class->new(items => $result);
}

=head2 items_by($key)

Возвращает структуру с измерителями, вида:
    $key eq 'banner_id'  => {$banner_id1 => [$href1, $href2, $href3], $banner_id2 => [$href4, ...], ...};

=cut

sub items_by {
    my ($self, $key) = @_;

    croak "by `banner_id` only supported" unless $key =~ /^(?:banner_id)$/;

    my %result;
    if ($key eq 'banner_id') {
        push @{$result{ $_->banner_id }}, $_ for @{$self->items};
    }

    return \%result;
}

1;
