package Direct::Banners::Dynamic;

use Mouse;
use Direct::Modern;

extends 'Direct::Banners';

use Direct::Model::BannerDynamic;
use Direct::Model::BannerDynamic::Manager;

use Direct::VCards qw/link_unlink_vcards_to_banners/;
use Direct::SitelinksSets qw/link_unlink_sitelinks_sets_to_banners/;
use Direct::BannerImages qw/link_unlink_images_to_banners/;
use Direct::BannersAdditions qw/link_unlink_additions_to_banners/;

use Exporter qw/import/;

has '+items' => (isa => 'ArrayRef[Direct::Model::BannerDynamic]');

=head2 manager_class
=cut

sub manager_class { 'Direct::Model::BannerDynamic::Manager' }


=head2 get($banner_ids, %options)

Аналогичен Direct::Banners->get с banner_type => 'dynamic'.

=cut

sub get {
    my ($class, $banner_ids, %options) = @_;
    $class->SUPER::get($banner_ids, %options, banner_type => 'dynamic');
}

=head2 get_by($key, $vals, %options)

Аналогичен Direct::Banners->get_by с banner_type => 'dynamic'.

=cut

sub get_by {
    my ($class, $key, $vals, %options) = @_;
    $class->SUPER::get_by($key, $vals, %options, banner_type => 'dynamic');
}

=head2 prepare_create($uid, %options)

Подготовка списка динамических баннеров к созданию для пользователя $uid.
%options унаследованы от родительского метода.

=cut

sub prepare_create {
    my ($self, $uid, %options) = @_;

    $self->SUPER::prepare_create($uid, %options);

    for my $banner (@{$self->items}) {
        if ($banner->do_moderate_adgroup) {
            # Если группа отправляется на модерацию,
            #   то поставим также статус генерации фраз в BannerLand в `Processing`
            $banner->do_set_adgroup_bl_status('Processing');
        }
    }

    link_unlink_vcards_to_banners($self->items);
    link_unlink_sitelinks_sets_to_banners($self->items);
    link_unlink_images_to_banners($self->items);
    link_unlink_additions_to_banners($self->items);

    return $self;
}

=head2 create($uid, %options)

Создание списка динамических баннеров в БД для пользователя $uid.
%options аналогичны prepare_create.

=cut

sub create {
    my ($self, $uid, %options) = @_;

    $self->set_client_id_by_uid($uid);
    $self->prepare_create($uid, %options);
    $self->prepare_logging('create', uid => $uid);
    $self->manager->create();
    $self->do_logging();

    return;
}

=head2 prepare_update

Подготовка списка динамических баннеров к обновлению.

=cut

sub prepare_update {
    my ($self) = @_;

    $self->SUPER::prepare_update();

    for my $banner (@{$self->items}) {
        if ($banner->do_moderate_adgroup) {
            # Если группа отправляется на модерацию,
            #   то поставим также статус генерации фраз в BannerLand в `Processing`
            $banner->do_set_adgroup_bl_status('Processing');
        }
    }

    link_unlink_vcards_to_banners($self->items);
    link_unlink_sitelinks_sets_to_banners($self->items);
    link_unlink_images_to_banners($self->items);
    link_unlink_additions_to_banners($self->items);

    return $self;
}

=head2 update($uid)

Обновление списка динамических баннеров в БД для пользователя $uid.

=cut

sub update {
    my ($self, $uid) = @_;

    $self->set_client_id_by_uid($uid);
    $self->prepare_update();
    $self->prepare_logging('update', uid => $uid);
    $self->manager->update();
    $self->do_logging();

    return;
}

=head2 prepare_moderate(%options)

Подготовка списка баннеров-черновиков к отправке на модерацию.

=cut

sub prepare_moderate {
    my ($self, %options) = @_;

    $self->SUPER::prepare_moderate(%options);

    for my $banner (@{$self->items}) {
        if ($banner->do_moderate_adgroup) {
            # Если группа отправляется на модерацию,
            #   то поставим также статус генерации фраз в BannerLand в `Processing`
            $banner->do_set_adgroup_bl_status('Processing');
        }
    }

    return $self;
}

1;
