package Direct::Banners::Measurers;

use Mouse;

use Direct::Modern;

use Settings;

use Direct::Model::Banner::Measurer;

use Yandex::DBTools;
use Yandex::DBShards;

has 'items' => (is => 'ro', isa => 'ArrayRef[Direct::Model::Banner::Measurer]');

around BUILDARGS => sub { my ($orig, $class) = (shift, shift); $class->$orig(@_ == 1 ? (items => $_[0]) : @_) };


=head2 get_by($key, $vals)

По заданному критерию возвращает instance с выбранными измерителями баннера.

Параметры:
    $key  -> по какому ключу выбирать: banner_id
    $vals -> (Int|ArrayRef[Int]); список идентификаторов

=cut

sub get_by {
    my ($class, $key, $vals) = @_;

    croak "only `banner_id` key is supported" unless $key =~ /^(?:banner)_id$/;

    $vals = [$vals // ()] if ref($vals) ne 'ARRAY';
    return $class->new(items => []) if !@$vals;

    my $measurers = get_all_sql(PPC(bid => $vals), [
        "SELECT m.bid, m.measurer_system, m.has_integration, m.params, b.cid AS campaign_id,
         b.pid AS adgroup_id, bp.creative_id, c.ClientID as client_id, p.adgroup_type
         FROM banner_measurers AS m
           JOIN banners AS b ON m.bid = b.bid
           JOIN phrases AS p ON b.pid = p.pid
           JOIN campaigns AS c ON b.cid = c.cid
           LEFT JOIN banners_performance AS bp ON bp.bid = b.bid",
        where => {
            'm.bid' => SHARD_IDS,
        }
    ]);

    my $_cache;
    my $result = [map {Direct::Model::Banner::Measurer->from_db_hash($_, \$_cache)} @$measurers];
    return $class->new(items => $result);
}

=head2 items_by($key)

Возвращает структуру с измерителями, вида:
    $key eq 'banner_id'  => {$banner_id1 => [$mesurer1, $measurer2], $banner_id2 => [$measurer3, ...], ...};

=cut

sub items_by {
    my ($self, $key) = @_;

    croak "by `banner_id` only supported" unless $key =~ /^(?:banner_id)$/;

    my %result;
    if ($key eq 'banner_id') {
        push @{$result{ $_->banner_id }}, $_ for @{$self->items};
    }

    return \%result;
}

1;
