package Direct::Banners::MobileContent;

use Mouse;
use Direct::Modern;

extends 'Direct::Banners';

use Direct::Model::BannerMobileContent;
use Direct::Model::BannerMobileContent::Manager;

use Direct::BannerImages qw/link_unlink_images_to_banners/;

has '+items' => (isa => 'ArrayRef[Direct::Model::BannerMobileContent]');

=head2 manager_class
=cut

sub manager_class { 'Direct::Model::BannerMobileContent::Manager' }


=head2 prepare_create($uid, %options)

Подготовка списка баннеров мобильного приложения к созданию для пользователя $uid.
%options унаследованы от родительского метода.

=cut

sub prepare_create {
    my ($self, $uid, %options) = @_;

    $self->SUPER::prepare_create($uid, %options);

    link_unlink_images_to_banners($self->items);
    $self->set_moderate_creatives();

    return $self;
}


=head2 create($uid, %options)

Создание баннеров мобильного приложения для одного пользователя.
Описание %options см. в prepapre_create.

=cut

sub create {
    my ($self, $uid, %options) = @_;

    $self->set_client_id_by_uid($uid);
    $self->prepare_create($uid, %options);
    $self->prepare_logging('create', uid => $uid);
    $self->manager->create();
    $self->do_logging();

    return;
}

=head2 prepare_update

=cut

sub prepare_update {
    my $self = shift;

    $self->SUPER::prepare_update();

    for my $banner (@{$self->items}) {
        if ($banner->is_reflected_attrs_changed || $banner->is_primary_action_changed) {
            $banner->status_bs_synced('No');
        }
    }

    link_unlink_images_to_banners($self->items);
    $self->set_remove_old_video_additions();
    $self->set_moderate_creatives();

    return $self;
}

=head2 update($uid)

=cut

sub update {
    my ($self, $uid) = @_;

    $self->set_client_id_by_uid($uid);
    $self->prepare_update();
    $self->prepare_logging('update', uid => $uid);
    $self->manager->update();
    $self->do_logging();

    return;
}

1;
