package Direct::Banners::Text;

use Mouse;
use Direct::Modern;

extends 'Direct::Banners';

use Direct::Model::BannerText;
use Direct::Model::BannerText::Manager;

use Direct::VCards qw/link_unlink_vcards_to_banners/;
use Direct::SitelinksSets qw/link_unlink_sitelinks_sets_to_banners/;
use Direct::DisplayHrefs qw/link_unlink_display_hrefs_to_banners/;
use Direct::BannerImages qw/link_unlink_images_to_banners/;
use Direct::BannersAdditions qw/link_unlink_additions_to_banners/;
use Direct::BannersResources qw/link_unlink_resources_to_banners/;

use Exporter qw/import/;

has '+items' => (isa => 'ArrayRef[Direct::Model::BannerText]');

=head2 manager_class
=cut

sub manager_class { 'Direct::Model::BannerText::Manager' }

=head2 get($banner_ids, %options)

Аналогичен Direct::Banners->get с banner_type => 'text'.

=cut

sub get {
    my ($class, $banner_ids, %options) = @_;
    $class->SUPER::get($banner_ids, %options, banner_type => 'text');
}

=head2 get_by($key, $vals, %options)

Аналогичен Direct::Banners->get_by с banner_type => 'text'.

=cut

sub get_by {
    my ($class, $key, $vals, %options) = @_;
    $class->SUPER::get_by($key, $vals, %options, banner_type => 'text');
}

=head2 prepapre_create($uid, %options)

Подготовка списка текстовых баннеров к созданию для пользователя $uid.
%options унаследованы от родительского метода.

=cut

sub prepare_create {
    my ($self, $uid, %options) = @_;

    $self->SUPER::prepare_create($uid, %options);

    link_unlink_vcards_to_banners($self->items);
    link_unlink_sitelinks_sets_to_banners($self->items);
    link_unlink_display_hrefs_to_banners($self->items);
    link_unlink_images_to_banners($self->items);
    link_unlink_additions_to_banners($self->items);
    $self->set_moderate_creatives();

    return $self;
}

=head2 create($uid, %options)

Создание списка текстовых баннеров в БД для пользователя $uid.
%options аналогичны prepare_create.

=cut

sub create {
    my ($self, $uid, %options) = @_;

    $self->set_client_id_by_uid($uid);
    $self->prepare_create($uid, %options);
    $self->prepare_logging('create', uid => $uid);
    $self->manager->create();
    $self->do_logging();

    return;
}

=head2 prepare_update

Подготовка списка текстовых баннеров к обновлению.

=cut

sub prepare_update {
    my ($self) = @_;

    $self->SUPER::prepare_update();

    link_unlink_vcards_to_banners($self->items);
    link_unlink_sitelinks_sets_to_banners($self->items);
    link_unlink_display_hrefs_to_banners($self->items);
    link_unlink_images_to_banners($self->items);
    link_unlink_additions_to_banners($self->items);
    link_unlink_resources_to_banners($self->items);
    $self->set_moderate_creatives();

    $self->set_remove_old_video_additions();

    return $self;
}

=head2 prepare_moderate

Подготовка списка баннеров к отправке на модерацию.

=cut

sub prepare_moderate {
    my ($self, %options) = @_;

    $self->SUPER::prepare_moderate(%options);
    for my $banner (@{$self->items}) {
        if ( $banner->has_creative ) {
            $banner->do_moderate_creative(1);
        }
    }

    return $self;
}




=head2 update($uid)

Обновление списка текстовых баннеров в БД для пользователя $uid.

=cut

sub update {
    my ($self, $uid) = @_;

    $self->set_client_id_by_uid($uid);
    $self->prepare_update();
    $self->prepare_logging('update', uid => $uid);
    $self->manager->update();
    $self->do_logging();

    return;
}

1;
