package Direct::BannersCreatives;

use Direct::Modern;

use Mouse;

use Settings;

use Yandex::DBTools;

use Direct::Model::Creative::Factory;
use Direct::Model::BannerCreative;
use Direct::Model::Creative;

use ShardingTools qw/choose_shard_param/;

has 'items' => (is => 'ro', isa => 'ArrayRef[Direct::Model::BannerCreative]');

=head2 get_by

=cut

sub get_by
{
    my ($class, $key, $val, %options) = @_;
    my $filter = $options{filter} // {};
    my $where = {};
    if ($key eq 'client_id') {
        $where->{'c.ClientID'} = $val;
    }
    else {
        die "invalid key $key";
    }

    if (!$filter->{campaign_id} && !@{$filter->{adgroup_id}//[]}) {
        return $class->new(items => []);
    }

    if ($filter->{campaign_id}) {
        $where->{'bp.cid'} = $filter->{campaign_id};
    }
    if ($filter->{adgroup_id}) {
        unless ($filter->{campaign_id}) {
            croak "adgroup_id must be used with campaign_id";
        }
        $where->{'bp.pid'} = delete $filter->{adgroup_id};
    }
    delete $filter->{campaign_id};

    my %shard = choose_shard_param($where, [qw/ClientID pid/], set_shard_ids => 1);

    if (keys %$filter) {
        die "invalid filter keys";
    }
    my @fields = (
        Direct::Model::BannerCreative->get_db_columns(banners_performance => 'bp', prefix => 'bp_'),
        Direct::Model::Creative->get_db_columns(perf_creatives => 'pc', prefix => 'pc_'),
    );
    my $fields = join ", ", @fields;
    my $rows = get_all_sql(PPC(%shard), [
        "select $fields from banners_performance bp
        join campaigns c on c.cid = bp.cid
        join perf_creatives pc on pc.creative_id = bp.creative_id",
        where => $where,
    ]);
    my $cache = {};
    my @items;
    for my $row (@$rows) {
        my $banner = Direct::Model::BannerCreative->from_db_hash($row, \$cache, prefix => 'bp_');
        my $creative = Direct::Model::Creative::Factory->create($row, \$cache, prefix => 'pc_');
        $banner->creative($creative);
        push @items, $banner;
    }
    return $class->new(items => \@items);
}

=head2 items_by

Вернуть хеш вида:
    { key => item }

=cut

sub items_by
{
    my ($self, $by) = @_;
    return { map { $_->$by => $_ } @{$self->items} };
}

1;
