package Direct::BannersPixels;

use Direct::Modern;

use Mouse;

use Settings;

use Direct::Model::Pixel;
use Direct::Model::Pixel::Manager;

use Yandex::DBTools;
use Yandex::DBShards;

has 'items' => (is => 'ro', isa => 'ArrayRef[Direct::Model::Pixel]');

=head2 get_by

По заданному критерию возвращает список пикселов баннеров (моделей Direct::Model::Pixel).

    my $pixels = Direct::Pixels::get_by(%opts);

где C<%opts>:

    banner_id - вернуть все пикселы для указанных баннеров

=cut

sub get_by {
    my ($class, %opt) = @_;

    my $bids = $opt{banner_id} // croak "Direct::BannersPixels->get_by() banner_id required";

    my $fields = join ',', Direct::Model::Pixel->get_db_columns('banner_pixels', 'bp', prefix => '');
    my $rows = get_all_sql(PPC(bid => $bids), [ "SELECT $fields, p.adgroup_type, p.cid AS campaign_id
						FROM banner_pixels AS bp
						     JOIN banners AS b USING(bid)
						     JOIN phrases AS p USING(pid)",
						WHERE => { 'bp.bid' => $bids } ]);
    
    return $class->new(items => Direct::Model::Pixel->from_db_hash_multi($rows));
}

=head2 items_by

    Вернуть сгруппированный по ключу хеш
    при группировке по banner_id:
        - в исходном объекте должен быть banner_id
        - не привязанные пикселы не возвращаются

=cut

sub items_by {
    my ($self, $key) = @_;

    $key //= 'banner_id';
    croak "by `banner_id` only supported" unless $key eq 'banner_id';

    my %result;
    for my $item (@{$self->items}) {
        next unless $item->banner_id;
        push @{$result{$item->banner_id}}, $item;
    }

    return \%result;
}

=head2 save

Сохранение списка пикселов

    Direct::Pixels->new(items => [Direct::Model::Pixel->new(client_id => 123, url => "http://pixel.url")])->save();

=cut

sub save {
    my ($self) = @_;

    Direct::Model::Pixel::Manager->new(items => $self->items)->save();
}

=head2 prepare_pixels_update

    Проставление нужных флагов на баннере при сохранении пикселов

    На входе список ArrayRef[Direct::Model::BannerCpmBanner] у которых заполненно поле pixels

=cut

sub prepare_pixels_update {
    my ($banners) = @_;

    for my $banner (@$banners) {
        my $old_pixel_urls_str = $banner->has_old && $banner->old->has_pixels ? $banner->old->pixel_urls_str : '';
        my $new_pixel_urls_str = $banner->has_pixels ? $banner->pixel_urls_str : '';
        next if $old_pixel_urls_str eq $new_pixel_urls_str;

        $banner->status_bs_synced('No');
        $banner->do_update_last_change(1);
        $banner->do_pixels_change(1);

        if ($banner->has_pixels && @{$banner->pixels}) {
            $_->banner_id($banner->id) foreach (@{$banner->pixels});
        }
    }

    return;
}

=head2 delete_banner_pixels($bids)

Удаление всех пикселов для указанных баннеров

=cut

sub delete_banner_pixels {
    my ($bids) = @_;

    do_sql(PPC(bid => $bids), ['DELETE FROM banner_pixels', WHERE => { bid => SHARD_IDS }]);

    return;
}

=head2 add_pixels_to_banners($banners)

В список баннеров добавить массив с пикселами, для интерфейса.
В каждый баннер добавляется ключ pixels с пикселами привязанными к баннеру.

=cut

sub add_pixels_to_banners {
    my ($banners) = @_;

    my $bids = [ map {$_->{bid}} grep { ((($_->{real_banner_type} // '') eq 'cpm_banner') || (($_->{real_banner_type} // '') eq 'cpm_audio'))  } @$banners ];
    if (@$bids) {
        my $pixels = Direct::BannersPixels->get_by(banner_id => $bids)->items_by('banner_id');
        for my $banner (@$banners) {
            $banner->{pixels} = exists $pixels->{$banner->{bid}} ? [ map {$_->to_template_hash} @{$pixels->{$banner->{bid}}} ] : [];
        }
    }

    return;
}


1;
