package Direct::BannersPlacementPages;

use Direct::Modern;

use Mouse;

use Settings;

use Direct::Model::BannerPlacementPage;

use Yandex::DBTools;

has 'items' => (is => 'ro', isa => 'ArrayRef[Direct::Model::BannerPlacementPage]');

=head2 get_by

По заданному критерию возвращает список результата модерации pageId баннеров (моделей Direct::Model::Placement).

    my $banner_moderate_pages = Direct::BannerPlacementPages::get_by(%opts);

где C<%opts>:

    banner_id - вернуть результаты модерации pageid для указанных баннеров

=cut

sub get_by {
    my ($class, %opt) = @_;

    my $bids = $opt{banner_id} // croak "Direct::BannerPlacementPage->get_by() banner_id required";
    my %where = (bid => $bids);

    $where{is_removed} = $opt{is_removed} if defined $opt{is_removed};

    my $fields = join ',', Direct::Model::BannerPlacementPage->get_db_columns_list('moderate_banner_pages');
    my $rows = get_all_sql(PPC(bid => $bids), [ "SELECT $fields FROM moderate_banner_pages", WHERE => \%where ]);

    return $class->new(items => Direct::Model::BannerPlacementPage->from_db_hash_multi($rows));
}

=head2 items_by

    Вернуть сгруппированный по ключу хеш
    при группировке по banner_id:
        - в исходном объекте должен быть banner_id

=cut

sub items_by {
    my ($self, $key) = @_;

    $key //= 'banner_id';
    croak "by `banner_id` only supported" unless $key eq 'banner_id';

    my %result;
    for my $item (@{$self->items}) {
        next unless $item->banner_id;
        push @{$result{$item->banner_id}}, $item;
    }

    return \%result;
}

=head2 add_banner_placement_pages_to_banners($banners)

В список баннеров добавить результат модерации pageId, для интерфейса.

=cut

sub add_banner_placement_pages_to_banners {
    my ($banners) = @_;

    my $bids = [ map {$_->{bid}} grep { ($_->{real_banner_type} // '') eq 'cpm_outdoor' } @$banners ];
    if (@$bids) {
        my $banner_moderate_pages = Direct::BannersPlacementPages->get_by(banner_id => $bids, is_removed => 0)->items_by('banner_id');
        for my $banner (@$banners) {
            $banner->{placement_pages} = exists $banner_moderate_pages->{$banner->{bid}} ? [ map {$_->to_template_hash} @{$banner_moderate_pages->{$banner->{bid}}} ] : [];
        }
    }

    return;
}

1;
