package Direct::BannersPrices;

use Direct::Modern;

use Mouse;

use Settings;

use Direct::Model::BannerPrice;

use Yandex::DBTools;

has 'items' => (is => 'ro', isa => 'ArrayRef[Direct::Model::BannerPrice]');

=head2 get_by

По заданному критерию возвращает список цен на товары на баннерах (моделей Direct::Model::BannerPrice).

    my $banner_prices = Direct::BannerPrices::get_by(%opts);

где C<%opts>:

    banner_id - вернуть цены на товары для указанных баннеров

=cut

sub get_by {
    my ($class, %opt) = @_;

    my $bids = $opt{banner_id} // croak "Direct::BannersPrice->get_by() banner_id required";

    my $fields = join ',', Direct::Model::BannerPrice->get_db_columns_list('banner_prices');
    my $rows = get_all_sql(PPC(bid => $bids), [ "SELECT $fields FROM banner_prices", WHERE => { bid => $bids } ]);

    return $class->new(items => Direct::Model::BannerPrice->from_db_hash_multi($rows));
}

=head2 items_by

    Вернуть сгруппированный по ключу хеш
    при группировке по banner_id:
        - в исходном объекте должен быть banner_id
        - не привязанные пикселы не возвращаются

=cut

sub items_by {
    my ($self, $key) = @_;

    $key //= 'banner_id';
    croak "by `banner_id` only supported" unless $key eq 'banner_id';

    my %result;
    for my $item (@{$self->items}) {
        next unless $item->banner_id;
        $result{$item->banner_id} = $item;
    }

    return \%result;
}

=head2 add_banner_prices_to_banners($banners)

В список баннеров добавить цены на товары, для интерфейса.
В каждый баннер добавляется ключ banner_price с ценами на товар на баннере.

=cut

sub add_banner_prices_to_banners {
    my ($banners) = @_;

    my $bids = [ map {$_->{bid}} grep { ($_->{real_banner_type} // '') eq 'text' } @$banners ];
    if (@$bids) {
        my $banner_prices = Direct::BannersPrices->get_by(banner_id => $bids)->items_by('banner_id');
        for my $banner (@$banners) {
            $banner->{banner_price} = exists $banner_prices->{$banner->{bid}} 
                    ? $banner_prices->{$banner->{bid}}->to_template_hash
                    : {};
        }
    }

    return;
}

1;
