package Direct::BannersResources;

use Direct::Modern;

use base qw/Exporter/;
our @EXPORT_OK = qw/
    link_unlink_resources_to_banners
    add_video_resources_to_banners
    /;

use JSON;
use Direct::MediaResources;

=head2 link_unlink_resources_to_banners($banners)

=cut

sub link_unlink_resources_to_banners {
    my ($banners) = @_;

    for my $banner (@$banners) {
        next unless $banner->is_creative_changed;

        $banner->do_update_last_change(1);
        $banner->status_bs_synced('No');
    }

    return $banners;
}

=head2 add_video_resources_to_banners

В список баннеров добавить видео дополнение, нужно для интерфейса.
В каждый баннер добавляется пара ключей:
    available_video_addition - 1|0, доступность видео дополнения для данного баннера
    used_resources - список дополнений (видео/аудио)

    TODO: available_video_addition на данном этапе всегда отдает 1, детали тут DIRECTMOD-7040

    Direct::BannersResources::add_video_resources_to_banners($banners);

=cut

sub add_video_resources_to_banners($) {
    my ($banners) = @_;

    for my $banner (@$banners) {
        $banner->{available_video_addition} = 1;
        if ($banner->{used_resources}) {
            $banner->{used_resources} = [
                map { $_->to_template_hash } @{ Direct::MediaResources->get_by(id => JSON::from_json($banner->{used_resources}))->items }
            ];
        } else {
            $banner->{used_resources} = [ ];
        }
    }
}

1;
