package Direct::Bids::BidRelevanceMatch;

use Mouse;
use Direct::Modern;

extends 'Direct::Bids';

use Direct::Model::BidRelevanceMatch::Manager;

has '+items' => (isa => 'ArrayRef[Direct::Model::BidRelevanceMatch]');

=head2 manager_class
=cut

sub manager_class { 'Direct::Model::BidRelevanceMatch::Manager' }

=head2 get_by($key, $vals, %options)

Аналогичен Direct::Bids->get с bid_type => 'relevance_match'.

=cut

sub get_by {
    my ($class, $key, $vals, %options) = @_;
    $class->SUPER::get_by($key, $vals, %options, bid_type => [qw/relevance_match relevance_match_search/]);
}

before 'prepare_delete' => sub {
        my ($self) = @_;

        for my $bid (@{$self->items}) {
            $bid->href_param1(undef);
            $bid->href_param2(undef);
        }
    };

1;
