package Direct::BrandSafetyConditions;

use Mouse;

use Direct::Modern;
use Carp qw/croak/;

use Direct::Model::BrandSafetyCondition::Manager;

use Settings;

extends 'Direct::RetargetingConditions';

has '+items' => (is => 'ro', isa => 'ArrayRef[Direct::Model::BrandSafetyCondition]');

=head2 manager_class
=head2 manager
=cut

sub manager_class { 'Direct::Model::BrandSafetyCondition::Manager' }
sub manager { $_[0]->manager_class->new(items => $_[0]->items) }

sub get_by {
    my ($class, $key, $vals, %options) = @_;

    return $class->SUPER::get_by($key, $vals, %options, filter => {retargeting_conditions_type => 'brandsafety'});
}

sub update {
    my ($self) = @_;
    croak 'update operation not supported for brand safety';
}

sub delete {
    my ($self) = @_;
    croak 'delete operation not supported for brand safety';
}
1;
