package Direct::Creatives::Dict;

use Direct::Modern;
use Yandex::I18n qw/iget_noop/;
use BannerStorage::Dict;

=head2 get_business_type

=cut


our $BUSINESS_TYPES = {
    retail => {
        name => iget_noop('Розничная торговля'),
        value => 'retail',
    },
    auto => {
        name => iget_noop('Автомобили'),
        value => 'auto',
    },
    hotels => {
        name => iget_noop('Отели'),
        value => 'hotels',
    },
    realty => {
        name => iget_noop('Недвижимость'),
        vale => 'realty',
    },
    flights => {
        name => iget_noop('Авиабилеты'),
        value => 'avia',
    },
    news => {
        name => iget_noop('Новости'),
        value => 'news',
    },
    other => {
        name => iget_noop('Другой бизнес'),
        value => 'other',
    },
    pharm => {
        name => iget_noop('Фармацевтика'),
        value => 'pharm',
    },
};

sub get_business_type
{
    return $BUSINESS_TYPES->{$_[0]} // {};
}

=head2 get_theme

=cut

sub get_theme
{
    return BannerStorage::Dict::get_dict('theme') // {};
}

1;
