package Direct::Creatives::Tools;

use Direct::Modern;
use Settings;
use Yandex::DBTools;
use Yandex::DBShards;

=head2 get_existing($creative_ids)

Проверяет, что id из переданного списка сответствуют существующим в БД креативам
Возвращает ссылку на хеш вида {creative_id1=>1, creative_id2=>1,  ...} где ключами являются идентификаторы креативов из переданного списка.


Параметры:
    $creative_ids -> список проверяемых идентификаторов креативов
    $creative_type - тип креатива

=cut

sub get_existing {
    my ($class, $client_id, $creative_ids, $creative_type) = @_;

    return get_hash_sql(PPC(creative_id => $creative_ids), [
        qq/SELECT creative_id, 1 FROM perf_creatives/,
        where => {
            creative_id => SHARD_IDS,
            creative_type => $creative_type,
            ( $client_id ? (ClientID => $client_id) : () ),
        }
    ]);
}


1;
