package Direct::DisplayHrefs;

use Direct::Modern;

use base qw/Exporter/;
our @EXPORT_OK = qw/
    link_unlink_display_hrefs_to_banners
/;

=head2 link_unlink_display_hrefs_to_banners($banners)

=cut

sub link_unlink_display_hrefs_to_banners {
    my ($banners) = @_;

    for my $banner (@$banners) {
        next if !$banner->is_display_href_changed && $banner->status_moderate ne 'Ready';

        $banner->do_update_last_change(1)  if $banner->is_display_href_changed;

        if ($banner->display_href) {
            $banner->display_href_status_moderate('Ready');
        }
        # отсеиваем ситуацию undef -> ""
        elsif ($banner->does_role('Update') && $banner->has_old && $banner->old->display_href) {
            $banner->do_delete_display_href_from_moderation(1);
            $banner->status_bs_synced('No');
        }
    }

    return $banners;
}

1;
