package Direct::Encrypt;
use strict;
use warnings;
use utf8;

=head1 NAME

Direct::Encrypt - функции шифрования для прозрачного показа пользователю важных данных.

=head1 DESCRIPTION

Произвольные данные пакуются в JSON и шифруются AES в режиме
CBC. Пользователь не понимает что именно хранится в зашифрованной
строке и не может её подделать.

=cut
use Crypt::CBC;
use JSON qw/encode_json decode_json/;
use Settings;
use parent qw/Exporter/;
our @EXPORT_OK = qw/encrypt_for_public decrypt_from_public encrypt_text decrypt_text/;

=head1 FUNCTIONS

=head2 encrypt_for_public

Зашифровать структуру данных для прозрачного её использования на
общедоступных страницах.

    $encrypted_string = encrypt_for_public($json_compatible_data);

=cut
sub encrypt_for_public ($) {
    return encrypt_text(encode_json(shift));
}

=head2 decrypt_from_public

Восстанавливает зашифрованную вызовом C<encrypt_for_public> структуру данных.

    $data = decrypt_from_public($encrypted_string);

=cut
sub decrypt_from_public ($) {
    return decode_json(decrypt_text(shift));
}

=head2 decrypt_text

=cut

sub decrypt_text
{
    my ($string) = @_;
    my $cipher = Crypt::CBC->new(
        -key => $Settings::SECRET_PHRASE,
        -cipher => 'Rijndael',
        -header => 'salt',
    );
    return $cipher->decrypt(pack "H*", $string);
}

=head2 encrypt_text

=cut

sub encrypt_text
{
    my ($string) = @_;
    my $cipher = Crypt::CBC->new(
        -key => $Settings::SECRET_PHRASE,
        -cipher => 'Rijndael',
        -header => 'salt',
    );
    return unpack "H*", $cipher->encrypt($string);
}

1;
