package Direct::Errors::Messages;

use strict;
use warnings;
use utf8;

=pod

    $Id$

=head1 NAME

    Direct::Errors::Messages - модуль агрегирующий ошибки и предупреждения, используемые в API.

=head1 SYNOPSIS

    use Direct::Errors::Messages;
    my $error = error_SomeError(
        'some error description text'
    );

    my $warning = warning_SomeError(
        'Some warning description text'
    );

=head1 DESCRIPTION

    Модуль с ошибками и ворнингами, которые используются в API.

    Формат описания ошибок см. в Direct::Errors, Direct::Defect

=cut

use Direct::Errors;

our $NO_HASH_TAG;

use Direct::Errors::Messages::Server;
use Direct::Errors::Messages::Client;
use Direct::Validation::Errors;


1;

__END__
