package Direct::Errors::Messages::Server;

use strict;
use warnings;
use utf8;

=pod

    $Id$

=head1 NAME

    Direct::Errors::Messages::Server - серверные ошибки API

=head1 SYNOPSIS

    use Direct::Errors::Messages::Server;
    my $error = error_SomeServerError(
        'some error description text'
    );

=head1 DESCRIPTION

    Модуль с серверными ошибками

    Формат описания ошибок см. в Direct::Errors;

    Коды серверных ошибок 1000..1999

=cut

use Direct::Errors;

error AuthTmpUnavail => ( # ошибка заимствована из API4
    code => 52,
    text => iget_noop("Сервер авторизации временно недоступен")
);

error FinOpsTmpUnavail => ( # ошибка заимствована из API4
    code => 358,
    text => iget_noop("Финансовые операции временно недоступны")
);

error PaymentProcError => ( # ошибка заимствована из API4
    code => 365,
    text => iget_noop("Не удалось провести платеж")
);

error TmpCmdUnavailable => ( # ошибка заимствована из API4
    code => 504,
    text => iget_noop("Плановый перерыв в работе сервера. Повторите запрос позже")
);

error ServerFailed => (
    code => 1000,
    text => iget_noop("Сервер временно недоступен")
);

error ServiceInitializationFailed => (
    code => 1001,
    text => iget_noop("Ошибка инициализации сервиса")
);

error OperationFailed => (
    code => 1002,
    text => iget_noop("Ошибка операции")
);


1;

__END__
