package Direct::GlobalVars;
use strict;
use warnings;
use feature qw(state);

=head1 NAME

Direct::GlobalVars

=head1 DESCRIPTION

Загружает файл, в котором определяются глобальные клиентские переменные (в контексте window) с информацией о текущей сборке

=cut

use Yandex::LiveFile;
use Settings;

my $DNA_BUILD_PATH = "$Settings::DNA_ROOT/build";

=head1 SUBROUTINES/METHODS

=head2 get_file_content

=cut

sub get_file_content {
    my $file_path = "$DNA_BUILD_PATH/globals.js";

    return "" unless -f $file_path;

    state $globals_vars;

    $globals_vars //= Yandex::LiveFile->new(filename => $file_path);

    return $globals_vars->data();
}

1;
