use strict;
use warnings;

package Direct::HttpResponse;

=head1 NAME

    Direct::HttpResponse - объект с данными для http-ответа web-интерфейса,
    который можно бросать как исключение

    Использовать только из Tools::error_*

=head1 DESCRIPTION

=cut

use Params::Validate qw/:all/;

=head2 Direct::HttpResponse->new(body => 'xxx', status => 404, type => 'text/html')

    Конструктор объекта.
    Возможные параметры:
      body - содержимое ответа
      status - http status, по-умолчанию 200
      type - Content-Type ответа, по умолчанию text/html

=cut
sub new {
    shift;
    validate(
        @_, {
            body => 0,
            body_sub => 0,
            type => 0,
            status => 0,
        });
    my $self = {@_};
    $self->{status} ||= 200;
    $self->{type} ||= 'text/html';
    return bless $self;
}

1;

