package Direct::ImageFormats;

use Direct::Modern;

use Mouse;

use Settings;
use ShardingTools;

use Yandex::DBTools;

use Direct::Model::ImageFormat;
use Direct::Model::ImagePool;

has 'items' => (is => 'ro', isa => 'ArrayRef[Direct::Model::ImageFormat]');

=head2 get_by

=cut

sub get_by {
    my ($class, $key, $vals, %opts) = @_;

    croak "only `client_id` or `banner_id` keys are supported" unless $key =~ /^(?:client|banner)_id$/;

    my %key2column = (
        client_id => 'imp.ClientID',
        banner_id => 'im.bid',
    );

    my %custom_where;
    my @tables = 'JOIN banner_images_formats imf using (image_hash)';
    if ($key eq 'banner_id') {
        push @tables, "JOIN images im using(image_hash)";
        push @tables , "JOIN campaigns c using(cid) join users u using(uid)";
        $custom_where{'imp.ClientID__dont_quote'} = 'u.ClientID';
    }

    $vals = [$vals // ()] if ref($vals) ne 'ARRAY';
    return $class->new(items => []) if !@$vals;

    my $col_pool = Direct::Model::ImagePool->get_db_columns(banner_images_pool => 'imp', prefix => 'imp_');
    my $col_formats = Direct::Model::ImageFormat->get_db_columns(banner_images_formats => 'imf', prefix => 'if_');

    for my $field (keys %{$opts{filter} // {}}) {
        $custom_where{$field =~ /^\w+\./ ? $field : 'imf.'.$field} = $opts{filter}->{$field};
    }

    my %where = (
        %custom_where,
        $key2column{$key} => $vals,
    );

    my %shard = choose_shard_param(\%where, [qw/ClientID bid/], set_shard_ids => 1);

    my $rows = get_all_sql(PPC(%shard), [
        SELECT => (join ',', $col_formats, $col_pool),
        FROM => 'banner_images_pool imp', (join "\n", @tables),
        WHERE => \%where,
    ]);

    my $items = [];
    my $cache = {};
    for my $row (@$rows) {
        my $format = Direct::Model::ImageFormat->from_db_hash($row, \$cache, prefix => 'if_');
        $format->name($row->{imp_name});
        push @$items, $format;
    }

    return $class->new(items => $items);
}

=head2 items_by

=cut

sub items_by
{
    my ($self, $by) = @_;
    my $res = {};
    if ($by eq 'hash') {
        for my $item (@{$self->items}) {
            $res->{$item->hash} = $item;
        }
    }
    else {
        croak "invalid `by` '$by'";
    }
    return $res;
}

=head2 to_template_array

=cut

sub to_template_array
{
    my $self = shift;
    return [ map { $_->to_template_hash } @{$self->items} ];
}

1;

