package Direct::InlineScript;
use strict;
use warnings;
use feature qw(state);

=head1 NAME

Direct::InlineScript

=head1 DESCRIPTION

Загружает файл с инлайн скриптом из DNA

=cut

use Yandex::LiveFile;
use Settings;

my $DNA_BUILD_PATH = "$Settings::DNA_ROOT/build";

=head1 SUBROUTINES/METHODS

=head2 get_file_content

=cut

sub get_file_content {
    my ($lang, $static_file_hashsums) = @_;
    my $file_key = "static/js/inline.$lang.js";

    if (!defined $static_file_hashsums->{$file_key}) {
        return "";
    }

    my $hashsum = $static_file_hashsums->{$file_key};
    my $file_path = "$DNA_BUILD_PATH/static/js/inline.$lang.$hashsum.js";

    return "" unless -f $file_path;

    state $inline_scripts = {};

    if (!defined $inline_scripts->{$file_path}) {
        my $inline_script //= Yandex::LiveFile->new(filename => $file_path);
        $inline_scripts->{$file_path} = $inline_script;
    }

    return $inline_scripts->{$file_path}->data();
}

1;
