package Direct::MediaResources;

use Direct::Modern;
use Mouse;
use Carp;
use List::Util qw/shuffle min/;
use Settings;

use Yandex::DBTools;
use Cache::SizeAwareMemoryCache;

use Direct::Model::MediaResource;

has 'items' => (is => 'ro', isa => 'ArrayRef[Direct::Model::MediaResource]');



=head2 get_by

    get_by

    получить ресурсы по media_resource_id

=cut

sub get_by {
    my ($class, $key, $vals) = @_;
    croak "only `id`  key are supported" unless $key eq 'id';

    $vals = [ $vals // () ] if ref($vals) ne 'ARRAY';
    return $class->new(items => [ ]) unless @$vals;

    my %ids = map {$_ => undef} @$vals;
    my $items = Direct::Model::MediaResource->from_db_hash_multi(
        [ grep {exists $ids{$_->{media_resource_id}}} @{ _get_media_resources_from_db() } ]
    );
    return $class->new(items => $items);
}

=head2 _get_media_resources_from_db

    _get_media_resources_from_db

    т.к. видео ресурсы будут добавляться редко, их общее число будет до 5 000
    и они нужны для каждого отображения тексто-графических баннеров, то кешируем их все в памяти

=cut

my $CACHE = Cache::SizeAwareMemoryCache->new( { namespace => 'MediaResources', default_expires_in => 60 * 60 } );
sub _get_media_resources_from_db {
    my $result = $CACHE->get( 'media_resources' );
    return $result if $result;

    my $media_resources = get_all_sql(
        PPCDICT, [
            qq/SELECT ${ \Direct::Model::MediaResource->get_db_columns('media_resources')} FROM `media_resources`/,
            where => [ resource_type__ne => 'undefined' ],
            q/ORDER BY `media_resource_id`/
        ]
    );

    $CACHE->set( media_resources => $media_resources );
    return $media_resources;
}

1;
