package Direct::Model::AbSegmentCondition;

use Direct::Modern;
use Yandex::ListUtils qw/nsort/;
use Mouse;
use Mouse::Util::TypeConstraints;
use Carp qw/croak/;

use Direct::Model::RetargetingCondition::Goal;
use Direct::Model::RetargetingCondition::Rule;

extends 'Direct::Model::RetargetingCondition';

has '+retargeting_conditions_type' => (isa => enum(['ab_segments']), lazy => 0, builder => sub { 'ab_segments' });

around BUILDARGS => sub {
        my ($orig, $class) = (shift, shift);
        my %args = @_ == 1 && ref($_[0]) eq 'HASH' ? %{$_[0]} : @_;

        if (defined $args{segments}) {
            my $segment_ids_by_section_id = {};
            for my $segment (@{delete $args{segments}}) {
                croak "section id must be defined for AbSegmentCondition" if !defined $segment->{section_id};
                push @{$segment_ids_by_section_id->{$segment->{section_id}} ||=[]}, $segment->{segment_id};
            }
            my @condition = ();
            #создаем условия
            for my $section_id (nsort keys %$segment_ids_by_section_id) {
                my $goals = [ map {Direct::Model::RetargetingCondition::Goal->new(goal_id =>
                    $_, goal_type => 'ab_segment')} @{$segment_ids_by_section_id->{$section_id}} ];
                push @condition, Direct::Model::RetargetingCondition::Rule->new(type => 'or', goals => $goals, section_id => int $section_id);
            }

            $args{condition} = \@condition;
        }

        if (defined $args{_condition_json}) {
            eval { $args{condition} = JSON->new->utf8(0)->decode($args{_condition_json}); 1; } or do { croak "Cannot apply `condition_json`: $@"; };
        }

        $class->$orig(%args);
    };

sub get_section_ids {
    my $ret_cond = shift;
    return [map {$_->section_id} @{$ret_cond->condition}];
}

sub get_segments_ids {
    my $ret_cond = shift;
    return [map {$_->goal_id} map {@$_} map {$_->goals} @{$ret_cond->condition}];
}

1;
