package Direct::Model::AdGroup;

use Direct::Modern;
use Mouse;
use Mouse::Util::TypeConstraints;

use JSON;
use HashingTools qw/url_hash_utf8/;
use MinusWordsTools;

extends 'Yandex::ORM::Model::Base';
with 'Direct::Model::AdGroup::Role::Extended', 'Direct::Model::Role::Update';

use constant ADGROUP_TYPE => enum [qw/base dynamic mobile_content performance mcbanner cpm_banner cpm_video cpm_outdoor cpm_yndx_frontpage cpm_geoproduct cpm_geo_pin cpm_indoor cpm_audio/];

__PACKAGE__->_setup(
    default_table  => 'phrases',

    fields => [
        id                     => { type => 'Id', column => 'pid', primary_key => 1 },
        campaign_id            => { type => 'Id', column => 'cid' },
        adgroup_name           => { type => 'Maybe[Str]', column => 'group_name', length => 255 },
        adgroup_type           => { type => ADGROUP_TYPE },
        geo                    => { type => 'Maybe[Str]' },
        bs_priority_id         => { type => 'Id', column => 'PriorityID', default => 0 },
        status_moderate        => { type => 'Enum', values => [qw/Yes No Sent Sending Ready New/], column => 'statusModerate', default => 'New', volatile => 1 },
        status_post_moderate   => { type => 'Enum', values => [qw/New Yes No Ready Sent Rejected/], column => 'statusPostModerate', default => 'No', volatile => 1 },
        status_bs_synced       => { type => 'Enum', values => [qw/Yes No Sending/], column => 'statusBsSynced', default => 'No', volatile => 1 },
        status_autobudget_show => { type => 'Enum', values => [qw/Yes No/], column => 'statusAutobudgetShow', default => 'Yes' },
        status_shows_forecast  => { type => 'Enum', values => [qw/New Processed Sending Archived/], column => 'statusShowsForecast', default => 'New' },
        forecast_date          => { type => 'Timestamp', column => 'forecastDate', default => '0000-00-00 00:00:00' },
        last_change            => { type => 'Timestamp', column => 'LastChange' },
        is_bs_rarely_loaded    => { type => 'Bool', default => 0 },

        _mw_id                 => { type => 'Maybe[Id]', column => 'mw_id' },

        has_phraseid_href      => { type => 'Bool', table => 'group_params', default => 0 },
        href_params            => { type => 'Maybe[Str]', table => 'group_params' },
    ],

    # Additional attributes
    additional => [
        # Должен быть заполнен всегда
        client_id => { type => 'Id' },

        # Гео-флаг для баннеров в группе
        geoflag   => { type => 'Bool' },

        # HierarchicalMultipliers
        hierarchical_multipliers       => { type => 'HashRef', trigger => \&_on_hierarchical_multipliers_changed },
        _hierarchical_multipliers_hash => { type => 'Str', track_changes => 1 },

        # Минус-слова
        minus_words       => { type => 'ArrayRef[Str]', trigger => \&_on_minus_words_changed },
        _minus_words_hash => { type => 'Str', track_changes => 1 },

        effective_geo => { type => 'ArrayRef[Int]' },
        # список регионов из adgroup.geo, который был исключен из  effective_geo
        disabled_geo  => { type => 'ArrayRef[Int]' },
        # объединение всех minus_geo со всех баннеров группы
        minus_geo     => { type => 'ArrayRef[Int]' },

        cpm_banners_type => { type => 'Str' },
    ],

    relations => [
        campaign => { type => 'Direct::Model::Campaign' },
        banners  => { type => 'ArrayRef[Direct::Model::Banner]' },
        tags     => { type => 'ArrayRef[Direct::Model::Tag]' },
        adgroup_bs_tags => {type => 'Maybe[Direct::Model::AdGroupBsTags]' },
    ],

    state_flags => [qw/
        update_last_change
        schedule_forecast
        update_status_post_moderate_unless_rejected
        update_banners_geoflag
        clear_banners_moderation_flags
        bs_sync_banners
        remoderate_banner_ids
    /],
);

sub _on_hierarchical_multipliers_changed {
    my ($self, $new) = @_;
    $self->_hierarchical_multipliers_hash(url_hash_utf8(JSON->new->utf8(0)->canonical->encode($self->hierarchical_multipliers)));
}

sub is_hierarchical_multipliers_changed { shift->_is_hierarchical_multipliers_hash_changed(@_) }

sub _on_minus_words_changed {
    my ($self, $new) = @_;
    $self->_minus_words_hash( MinusWordsTools::minus_words_utf8_hashcode($new) );
}

sub is_minus_words_changed { shift->_is_minus_words_hash_changed(@_) }

1;
