package Direct::Model::AdGroup::Role::Extended;

use Direct::Modern;
use Mouse::Role;

# Количество баннеров в группе
has 'banners_count' => (
    traits     => [qw/Yandex::ORM::Meta::Attribute::Trait::Column/],
    is         => 'rw',
    isa        => 'Int',
    lazy_build => 1,
);

# Количество заархивированных баннеров в группе
has 'archived_banners_count' => (
    traits     => [qw/Yandex::ORM::Meta::Attribute::Trait::Column/],
    is         => 'rw',
    isa        => 'Int',
    lazy_build => 1,
);

# Есть ли на группе условия показа (ключевые слова или ретаргетинг)
has 'has_show_conditions' => (
    traits     => [qw/Yandex::ORM::Meta::Attribute::Trait::Column/],
    is         => 'rw',
    isa        => 'Bool',
    lazy_build => 1,
);

# Признак архивности группы
sub is_archived {
    my ($self) = @_;
    return unless ($self->has_banners_count && $self->has_archived_banners_count);
    return $self->banners_count > 0 && $self->banners_count == $self->archived_banners_count;
}

# Признак полноты группы
sub is_completed {
    my ($self) = @_;
    return $self->banners_count && $self->has_show_conditions;
}

1;
