package Direct::Model::AdGroupCpmBanner::Manager;

use Direct::Modern;
use Mouse;

use Settings;

use Yandex::DBTools;

extends 'Direct::Model::AdGroup::Manager';

has '+items' => (isa => 'ArrayRef[Direct::Model::AdGroupCpmBanner]');

=head2 _create_in_shard($shard, $adgroups)

Создание в БД в определённом шарде записей для соответствующих объектов (медийных групп объявлений).

=cut

sub _create_in_shard {
    my ($self, $shard, $adgroups) = @_;

    my @columns = Direct::Model::AdGroupCpmBanner->get_db_columns_list('adgroups_cpm_banner');

    do_in_transaction {
        # Создадим базовые группы
        $self->SUPER::_create_in_shard($shard, $adgroups);
        $self->_insert_to_secondary_table_in_db(PPC(shard => $shard), 'adgroups_cpm_banner', phrases => 'pid', \@columns, $adgroups);
    };

    return;
}

=head2 _update_in_shard($shard, $adgroups)

Обновление в БД в определённом шарде записей для соответствующих объектов (медийных групп объявлений).

=cut

sub _update_in_shard {
    my ($self, $shard, $adgroups) = @_;

    do_in_transaction {
        # Обновим базовые группы
        $self->SUPER::_update_in_shard($shard, $adgroups);
        $self->_update_one_table_in_db(PPC(shard => $shard), adgroups_cpm_banner => 'pid', $adgroups);
    };

    return;
}

__PACKAGE__->meta->make_immutable;

1;
