package Direct::Model::AdGroupCpmGeoproduct;

use Direct::Modern;
use Mouse;
use Mouse::Util::TypeConstraints;

use Yandex::ORM::Types;

extends 'Direct::Model::AdGroup';
with 'Direct::Model::AdGroupCpmBanner::Role::Extended';

__PACKAGE__->_setup(
    manager_class  => __PACKAGE__.'::Manager',

    fields => [
        criterion_type => { type => 'Maybe[Enum]', values => [qw/keyword user_profile/], table => 'adgroups_cpm_banner' },
    ],

    relations => [
        keywords        => { type => 'ArrayRef' },
        retargetings    => { type => 'ArrayRef' },
    ],

    additional => [
        has_private_criterion => { type => 'Bool' },
    ],
);

has '+adgroup_type' => (isa => enum(['cpm_geoproduct']), lazy => 0, builder => sub { 'cpm_geoproduct' });

has '+banners' => (isa => 'ArrayRef[Direct::Model::BannerCpmBanner]');

1;
