package Direct::Model::AdGroupCpmOutdoor;

use Direct::Modern;
use Mouse;
use Mouse::Util::TypeConstraints;

use Yandex::ORM::Types;

extends 'Direct::Model::AdGroup';
with 'Direct::Model::AdGroupCpmBanner::Role::Extended';

=head2 OUTDOOR_GOALS_AUDITORY_TYPES

    Виды целей для блока "Сбор Я.Аудиторий" в настройках на всю группу

=cut
our $OUTDOOR_GOALS_AUDITORY_TYPES = ['start'];


__PACKAGE__->_setup(
    manager_class  => __PACKAGE__.'::Manager',

    fields => [
        page_blocks => { type => 'Str', column => 'page_blocks', table => 'adgroup_page_targets' },
    ],

    relations => [
        retargetings    => { type => 'ArrayRef' },
    ],

    additional => [
        has_private_criterion => { type => 'Bool' },
    ],
);

has '+adgroup_type' => (isa => enum(['cpm_outdoor']), lazy => 0, builder => sub { 'cpm_outdoor' });

has '+banners' => (isa => 'ArrayRef[Direct::Model::BannerCpmOutdoor]');

1;
