package Direct::Model::AdGroupCpmVideo;

use Direct::Modern;
use Mouse;
use Mouse::Util::TypeConstraints;

use Yandex::ORM::Types;

extends 'Direct::Model::AdGroup';
with 'Direct::Model::AdGroupCpmBanner::Role::Extended';

__PACKAGE__->_setup(
    manager_class  => __PACKAGE__.'::Manager',

    relations => [
        keywords        => { type => 'ArrayRef' },
        retargetings    => { type => 'ArrayRef' },
    ],

    additional => [
        has_private_criterion => { type => 'Bool' },
    ],
);

has '+adgroup_type' => (isa => enum(['cpm_video']), lazy => 0, builder => sub { 'cpm_video' });

has '+banners' => (isa => 'ArrayRef[Direct::Model::BannerCpmBanner]');

1;
