package Direct::Model::AdGroupDynamic;

use Direct::Modern;
use Mouse;
use Mouse::Util::TypeConstraints;
use Direct::Model::DynamicCondition;

extends 'Direct::Model::AdGroup';
with 'Direct::Model::AdGroupDynamic::Role::Extended';

__PACKAGE__->_setup(
    default_table  => 'adgroups_dynamic',
    manager_class  => __PACKAGE__.'::Manager',

    fields => [
        _main_domain_id            => { type => 'Maybe[Id]', column => 'main_domain_id' },
        main_domain                => { type => 'Maybe[Str]', length => 100, table => 'domains', column => 'domain', alias => 'main_domain', trigger => \&_on_main_domain_changed },
        feed_id                    => { type => 'Maybe[Id]', alias => 'dynamic_feed_id' },

        relevance_match_categories => { type => 'Str', default => '' },

        status_bl_generated        => { type => 'Enum', values => [qw/No Processing Yes/], column => 'statusBlGenerated', default => 'No', alias => 'dyn_statusBlGenerated' },
    ],

    relations => [
        dynamic_conditions => { type => 'ArrayRef[Direct::Model::DynamicCondition]' },
    ],
);

has '+adgroup_type'      => (isa => enum(['dynamic']), lazy => 0, builder => sub { 'dynamic' });
has '+has_phraseid_href' => (isa => 'OnlyFalse', builder => sub { 0 });

has '+banners' => (isa => 'ArrayRef[Direct::Model::BannerDynamic]');

sub _on_main_domain_changed {
    my ($self, $new) = @_;
    $self->_main_domain_id(undef) if $self->_constructed && !$new;
}

sub get_class_for_condition_rules {
    my ($self) = @_;
    
    return $self->has_feed_id && $self->feed_id ? 'Direct::Model::DynamicCondition::FeedRule' : 'Direct::Model::DynamicCondition::Rule';
}

1;
