package Direct::Model::AdGroupMobileContent;

use Direct::Modern;
use Mouse;
use Mouse::Util::TypeConstraints;

extends 'Direct::Model::AdGroup';
with 'Direct::Model::AdGroupMobileContent::Role::Extended';

__PACKAGE__->_setup(
    default_table  => 'adgroups_mobile_content',
    manager_class  => __PACKAGE__.'::Manager',

    fields => [
        store_content_href      => { type => 'Str', length => 1024 },
        mobile_content_id       => { type => 'Id' },
        device_type_targeting   => { type => 'Set', values => [qw/phone tablet/] },
        network_targeting       => { type => 'Set', values => [qw/wifi cell/] },
        min_os_version          => { type => 'Str', length => 10 },
    ],

    relations => [
        retargetings     => { type => 'ArrayRef' },
        target_interests => { type => 'ArrayRef' },
        keywords         => { type => 'ArrayRef' },

        mobile_content => { type => 'Direct::Model::MobileContent', key => 'mobile_content_id' },
    ]
);

has '+adgroup_type' => (isa => enum(['mobile_content']), lazy => 0, builder => sub { 'mobile_content' });

has '+banners' => (isa => 'ArrayRef[Direct::Model::BannerMobileContent | Direct::Model::BannerImageAd | Direct::Model::BannerCpcVideo]');

1;
