package Direct::Model::AdGroupPerformance;

use Direct::Modern;
use Mouse;
use Mouse::Util::TypeConstraints;

extends 'Direct::Model::AdGroup';
with 'Direct::Model::AdGroupPerformance::Role::Extended';

__PACKAGE__->_setup(
    default_table  => 'adgroups_performance',
    manager_class  => __PACKAGE__.'::Manager',

    fields => [
        feed_id => { type => 'Id', alias => 'performance_feed_id' },
        status_bl_generated => { type => 'Enum', values => [qw/No Processing Yes/], column => 'statusBlGenerated', default => 'No', alias => 'perf_statusBlGenerated' },
        field_to_use_as_name => { type => 'Maybe[Str]', default => undef },
        field_to_use_as_body => { type => 'Maybe[Str]', default => undef },
    ],

    relations => [
        performance_filters => { type => 'ArrayRef[Direct::Model::PerformanceFilter]' },
    ],
    
    state_flags => [qw/
        set_geo_for_draft_creatives   
    /]
);

has '+adgroup_type'      => (isa => enum(['performance']), lazy => 0, builder => sub { 'performance' });
has '+has_phraseid_href' => (isa => 'OnlyFalse', builder => sub { 0 });

has '+banners' => (isa => 'ArrayRef[Direct::Model::BannerPerformance]');

1;
