package Direct::Model::AdGroupPerformance::Manager;

use Direct::Modern;
use Mouse;

extends 'Direct::Model::AdGroup::Manager';

use Settings;

use Yandex::DBTools;

use Direct::Model::AdGroupPerformance;
use Direct::Model::BannerPerformance::Manager;

has '+items' => (isa => 'ArrayRef[Direct::Model::AdGroupPerformance]');

=head2 _create_in_shard($shard, $adgroups)

Внутренний метод.
Создание в БД в определённом шарде записей для соответствующих объектов (групп перфоманс объявлений).

=cut

sub _create_in_shard {
    my ($self, $shard, $adgroups) = @_;

    my @columns = Direct::Model::AdGroupPerformance->get_db_columns_list('adgroups_performance');

    do_in_transaction {
        # Создадим базовые группы
        $self->SUPER::_create_in_shard($shard, $adgroups);

        $self->_insert_to_secondary_table_in_db(PPC(shard => $shard), 'adgroups_performance', phrases => 'pid', \@columns, $adgroups);
    };

    return;
}

=head2 _update_in_shard($shard, $adgroups)

Внутренний метод.
Обновление в БД в определённом шарде записей для соответствующих объектов (групп перфоманс объявлений).

=cut

sub _update_in_shard {
    my ($self, $shard, $adgroups) = @_;

    do_in_transaction {
        # Обновим базовые группы
        $self->SUPER::_update_in_shard($shard, $adgroups);
        $self->_do_set_geo_for_draft_creatives($shard, $adgroups);
        $self->_update_one_table_in_db(PPC(shard => $shard), adgroups_performance => 'pid', $adgroups);
    };

    return;
}

sub _do_set_geo_for_draft_creatives {
    my ($self, $shard, $adgroups) = @_;
    
    my %affected_adgroups;
    foreach my $adgroup (@$adgroups){
        next unless $adgroup->do_set_geo_for_draft_creatives;
        $affected_adgroups{$adgroup->id} = $adgroup;
    }
    return unless keys %affected_adgroups;
    
    my $creative2adgroup = get_hash_sql(PPC(shard => $shard), [
        'SELECT creative_id, pid FROM perf_creatives pc JOIN banners_performance bp USING(creative_id)',
        WHERE => {
            'pc.statusModerate' => [qw/New Error/],
            'bp.pid' => [keys %affected_adgroups]
        },
        'FOR UPDATE'
    ]);
    return unless keys %$creative2adgroup;
   
    my @creative_ids = keys %$creative2adgroup;
    my $case_values = Direct::Model::BannerPerformance::Manager->get_joined_geo({
            map {
                $_ => $affected_adgroups{ $creative2adgroup->{$_}}->do_set_geo_for_draft_creatives->{translocal_opt}
            } @creative_ids 
    });
       
    do_update_table(PPC(shard => $shard), 'perf_creatives', {
        sum_geo__dont_quote => sql_case(creative_id => $case_values, default__dont_quote => 'sum_geo'),
    }, where => {
        creative_id => \@creative_ids,
        statusModerate => ['New', 'Error'],
    });

}

__PACKAGE__->meta->make_immutable;

1;
