package Direct::Model::AdGroupText;

use Direct::Modern;
use Mouse;
use Mouse::Util::TypeConstraints;

use Yandex::ORM::Types;

extends 'Direct::Model::AdGroup';
with 'Direct::Model::AdGroupText::Role::Extended';

__PACKAGE__->_setup(
    manager_class  => __PACKAGE__.'::Manager',

    relations => [
        retargetings    => { type => 'ArrayRef' },
        keywords        => { type => 'ArrayRef' },
        relevance_match => { type => 'ArrayRef' },
    ],
);

has '+adgroup_type' => (isa => enum(['base']), lazy => 0, builder => sub { 'base' });

has '+banners' => (isa => 'ArrayRef[Direct::Model::BannerText|Direct::Model::BannerImageAd|Direct::Model::BannerCpcVideo]');

1;
