package Direct::Model::AdditionsItem;

=head1 DESCRIPTION

Базовый класс для модели дополнений

Закладываемся на наличее полей

        id              => {type => 'Id', column => 'additions_item_id', primary_key => 1},
        client_id       => {type => 'Id', column => 'ClientID'},
        hash            => {type => 'Int'},
        create_time     => {type => 'Timestamp'},



=cut

use Direct::Modern;

use Mouse;

use HashingTools qw/url_hash_utf8/;
use POSIX qw/strftime/;

extends 'Yandex::ORM::Model::Base';
with 'Direct::Model::Role::MarkNewItems';


sub _get_data_for_hash {
    die 'Base method must be redefined';
}


=head2 uniq_key

Вычисление уникального ключа (client_id + hash)

=cut

sub uniq_key {
    my $self = shift;

    $self->calc_hash();
    return join '/' => ($self->client_id, $self->hash);
}



=head2 calc_hash

Вычисление хеша у одного коллаута, и заполнение hash, его же возвращаем

    $callout->calc_hash();
    my $hash = $callout->calc_hash();

=cut

sub calc_hash {
    my ($self) = @_;

    my $hash;
    if (! $self->has_hash) {
        $hash = get_hash($self->_get_data_for_hash);
        $self->hash($hash);
    }

    return $hash || $self->hash;
}

=head2 set_datetimes

Выставление времени создания и времени модерации

    $callout->set_datetimes();

=cut

sub set_datetimes {
    my ($self) = @_;

    if (! $self->has_create_time) {
        $self->create_time(strftime("%Y-%m-%d %H:%M:%S", localtime()));
    }
}

=head2 get_hash

Вычисление хеша

    my $hash = Direct::Model::AdditionsItemCallout::get_hash("text");

=cut

sub get_hash {
    my ($text) = @_;

    return url_hash_utf8($text);
}


=head2 is_item_changed

$item->is_item_changed() - возвращает признак, что объект был изменен

=cut

sub is_item_changed {
    my ($self) = @_;

    return
        $self->is_client_id_changed
        || $self->is_hash_changed
        || $self->is_create_time_changed;
}


1;
