package Direct::Model::AdditionsItemCallout;

use Direct::Modern;

use Mouse;

use Yandex::HashUtils qw/hash_cut/;
use POSIX qw/strftime/;


extends 'Direct::Model::AdditionsItem';


__PACKAGE__->_setup(
    default_table => 'additions_item_callouts',

    fields => [
        id              => {type => 'Id', column => 'additions_item_id', primary_key => 1},
        client_id       => {type => 'Id', column => 'ClientID'},
        hash            => {type => 'Int'},
        callout_text    => {type => 'Str', length => 255},
        status_moderate => {type => 'Enum', values => [qw/Yes No Sent Sending Ready New/], column => 'statusModerate', default => 'New', volatile => 1},
        flags           => {type => 'Maybe[Str]'},
        last_change     => {type => 'Timestamp'},
        create_time     => {type => 'Timestamp'},
        is_deleted      => {type => 'Bool', default => 0},
    ],

    additional => [
        banner_id          => {type => 'Maybe[Id]', column => 'bid'},
        moderation_reasons => {type => 'Maybe[ArrayRef]'},
        is_linked          => {type => 'Bool', default => 0}, # привязан ли коллаут к какому либо баннеру
    ],
);


sub additions_item_type { 'callout' }


sub _get_data_for_hash {
    my $self = shift;
    return $self->callout_text;
}



=head2 to_template_hash

Преобразование из объекта в хеш, для отдачи фронтенду

=cut

sub to_template_hash {
    my ($self) = @_;

    my $hash = $self->SUPER::to_hash();
    $hash = hash_cut $hash, qw/id callout_text status_moderate/;
    $hash->{additions_item_id} = delete $hash->{id};

    return $hash;
}

=head2 is_item_changed

$item->is_item_changed() - возвращает признак, что объект был изменен

=cut

sub is_item_changed {
    my ($self) = @_;

    return $self->SUPER::is_item_changed()
           || $self->is_callout_text_changed
           || $self->is_flags_changed
           || $self->is_is_deleted_changed
           || $self->is_status_moderate_changed
           || $self->is_last_change_changed;
}


=head2 set_last_change

Выставление времени модерации

    $callout->set_last_change();

=cut

sub set_last_change {
    my ($self) = @_;

    $self->last_change(strftime("%Y-%m-%d %H:%M:%S", localtime()));
}

=head2 set_datetimes

Выставление времени создания и времени модерации

    $callout->set_datetimes();

=cut

sub set_datetimes {
    my ($self) = @_;

    if (! $self->has_last_change) {
        $self->set_last_change();
    }

    return $self->SUPER::set_datetimes();
}
1;
