package Direct::Model::AdditionsItemDisclaimer;

use Direct::Modern;

use Mouse;

use Yandex::HashUtils qw/hash_cut/;

extends 'Direct::Model::AdditionsItem';


__PACKAGE__->_setup(
    default_table => 'additions_item_disclaimers',

    fields => [
        id              => {type => 'Id', column => 'additions_item_id', primary_key => 1},
        client_id       => {type => 'Id', column => 'ClientID'},
        hash            => {type => 'Int'},
        disclaimer_text => {type => 'Str'},
        create_time     => {type => 'Timestamp'},
    ],

    additional => [
        banner_id          => {type => 'Maybe[Id]', column => 'bid'},
        is_linked          => {type => 'Bool', default => 0},
    ],
);


sub additions_item_type { 'disclaimer' }


sub _get_data_for_hash {
    my $self = shift;
    return $self->disclaimer_text;
}



=head2 to_template_hash

Преобразование из объекта в хеш, для отдачи фронтенду

=cut

sub to_template_hash {
    my ($self) = @_;

    my $hash = $self->SUPER::to_hash();
    $hash = hash_cut $hash, qw/id disclaimer_text/;
    $hash->{additions_item_id} = delete $hash->{id};

    return $hash;
}

=head2 is_item_changed

$item->is_item_changed() - возвращает признак, что объект был изменен

=cut

sub is_item_changed {
    my ($self) = @_;

    return $self->SUPER::is_item_changed()
           || $self->is_disclaimer_text_changed;
}

1;
