package Direct::Model::AdditionsItemDisclaimer::Manager;

use Direct::Modern;
use Mouse;

use Yandex::DBShards;
use Yandex::DBTools;
use Yandex::ListUtils qw/xuniq/;

use Settings;
use Direct::Model::AdditionsItemDisclaimer;

extends 'Yandex::ORM::Model::Manager::Base';

has 'items' => (
    is  => 'ro',
    isa => 'ArrayRef[Direct::Model::AdditionsItemDisclaimer]',
);




=head2 create

Сохранение дисклеймеров: новые записываем, для старых подставляем id

=cut

sub create {
    my ($self) = @_;
    my @columns = Direct::Model::AdditionsItemDisclaimer->get_db_columns_list('additions_item_disclaimers');

    for my $chunk (sharded_chunks(ClientID => $self->items, by => sub { $_->client_id })) {
        my ($shard, $shard_items) = ($chunk->{shard}, $chunk->{ClientID});

        my @uniq_items = xuniq {$_->uniq_key} @$shard_items;
        my @shard_conditions =
            map {(_AND => {ClientID => $_->client_id, hash => $_->hash})}
            @uniq_items;

        my $exist_item_id = get_hash_sql(PPC(shard => $shard), [
                'SELECT concat(ClientID, "/", hash) as uniq_key, additions_item_id
                FROM additions_item_disclaimers',
                WHERE => { _OR => \@shard_conditions },
            ]);

        my %new_item_id;
        my @new_items = grep {!$exist_item_id->{$_->uniq_key}} @uniq_items;
        if (@new_items) {
            my $new_ids = get_new_id_multi('additions_item_id', scalar @new_items);
            for my $new_item (@new_items) {
                my $id = shift @$new_ids;
                $new_item->id($id);
                $new_item->set_datetimes();
                $new_item_id{$new_item->uniq_key} = $id;
            }

            $self->_insert_to_one_table_in_db(PPC(shard => $shard), 'additions_item_disclaimers', \@columns, \@new_items);
        }

        # проставляем id на всех item-ах в объекте
        for my $item (@$shard_items) {
            next if $item->has_id;
            my $key = $item->uniq_key;
            my $id = $exist_item_id->{$key} || $new_item_id{$key};
            die "No id for disclaimer $key"  if !$id; # assertion
            $item->id($id);
        }
    }

    return;
}


1;
