package Direct::Model::AdditionsItemExperiment;

use Direct::Modern;

use Mouse;

extends 'Direct::Model::AdditionsItem';


__PACKAGE__->_setup(
    default_table => 'additions_item_experiments',

    fields => [
        id              => {type => 'Id', column => 'additions_item_id', primary_key => 1},
        client_id       => {type => 'Id', column => 'ClientID'},
        hash            => {type => 'Int'},
        experiment_json => {type => 'Str'},
        create_time     => {type => 'Timestamp'},
    ],

    additional => [
        banner_id          => {type => 'Maybe[Id]', column => 'bid'},
        is_linked          => {type => 'Bool', default => 0},
    ],
);

sub additions_item_type { 'experiment' }


sub _get_data_for_hash {
    my $self = shift;
    return $self->experiment_json;
}

=head2 is_item_changed

$item->is_item_changed() - возвращает признак, что объект был изменен

=cut

sub is_item_changed {
    my ($self) = @_;

    return $self->SUPER::is_item_changed()
           || $self->is_experiment_json_changed;
}

1;
