package Direct::Model::AgencyOptions;

use Direct::Modern;
use Mouse;
use Readonly;

extends 'Yandex::ORM::Model::Base';
with 'Direct::Model::Role::Update';

Readonly my $DEFAULT_TABLE => 'agency_options';

__PACKAGE__->_setup(
    default_table  => $DEFAULT_TABLE,

    fields => [
        id                              => { type => 'Int', column => 'ClientID', primary_key => 1 },
        allow_clients_without_wallet    => { type => 'Int' },
        default_clients_with_wallet     => { type => 'Int' },
        deal_notification_email         => { type => 'Str' },
    ],
);

=head2 get_db_columns($class, $table, $table_alias, %options)

    Обертка над Yandex::ORM::Model::Base->get_db_columns, которая по умолчанию указывает в качестве $table_alias не
    пустоту, а имя таблицы. А в качестве префикса к колонкам - 'agency_options_'
    Так получается более безопасный default

=cut

sub get_db_columns {
    my ($class, $table, $table_alias, %options) = @_;

    $options{prefix} //= (defined $table_alias ? $table_alias.'_' : $DEFAULT_TABLE.'_');
    $table_alias //= $table;
    return $class->SUPER::get_db_columns($table, $table_alias, %options);
}

=head2 from_db_hash($class, $row, $cache, %options)

    Обертка над Yandex::ORM::Model::Base->from_db_hash, которая по умолчанию указывает в качестве префикса не пустоту,
    а 'agency_options_', для совместимости с умолчальным поведением get_db_columns

=cut

sub from_db_hash {
    my ($class, $row, $cache, %options) = @_;

    unless (defined($options{prefix})) {
        $options{prefix} = $DEFAULT_TABLE.'_';
    }

    return $class->SUPER::from_db_hash($row, $cache, %options, delete_from_hash => 1);
}

=head2 to_template_hash($self)

    Приведение объекта модели к хешику, который ожидает шаблонизация.

=cut

sub to_template_hash {
    my ($self) = @_;

    return {
        allow_clients_without_wallet    => int($self->allow_clients_without_wallet()),
        default_clients_with_wallet     => int($self->default_clients_with_wallet()),
        deal_notification_email         => $self->deal_notification_email(),
    };
}

1;
