package Direct::Model::AgencyOptions::Manager;

use Direct::Modern;
use Mouse;

extends 'Yandex::ORM::Model::Manager::Base';

use Settings;

use Yandex::DBShards;

use Direct::Model::AgencyOptions;

has 'items' => (is => 'ro', isa => 'ArrayRef[Direct::Model::AgencyOptions]');

=head2 update(%options)

Обновление в БД записей для соответствующих объектов

=cut

sub update {
    my ($self) = @_;

    for my $chunk (sharded_chunks(ClientID => $self->items, by => sub { $_->id })) {
        my ($shard, $shard_items) = ($chunk->{shard}, $chunk->{ClientID});
        $self->_update_in_shard($shard, $shard_items);
    }

    $_->reset_state() for @{$self->items};

    return;
}

sub _update_in_shard {
    my ($self, $shard, $agency_options_items) = @_;

    $self->_update_one_table_in_db(PPC(shard => $shard), 'agency_options' => 'ClientID', $agency_options_items);

    return;
}


__PACKAGE__->meta->make_immutable;

1;
