package Direct::Model::Autopay;

use Direct::Modern;
use Mouse;

extends 'Yandex::ORM::Model::Base';

__PACKAGE__->_setup(
    default_table  => 'autopay_settings',

    fields => [
        id                  => { type => 'Id', column => 'wallet_cid', primary_key => 1 },
        user_id             => { type => 'Id', column => 'payer_uid' },
        paymethod_type      => { type => 'Enum', values => [qw/card yandex_money/], default => 'card' },
        paymethod_id        => { type => 'Str' },
        remaining_sum       => { type => 'Num', default => 0 },
        payment_sum         => { type => 'Num', default => 0 },
        tries_num           => { type => 'Num', default => 0 },
        person_id           => { type => 'Maybe[Num]' },
    ],

    additional => [
        currency            => { type => 'Enum', values => [qw/RUB UAH/], default => 'RUB' }, # Валюта клиентов, которым доступна функция автопополнения
        min_payment_sum     => { type => 'Num', default => 0 },
        max_payment_sum     => { type => 'Num', default => 0 },
        last_transaction_status => { type => 'Maybe[Str]' }
    ],

);

=head2 to_template_hash

Хэш с данными для клиентского интерфейса.

=cut
sub to_template_hash {
    my ($self, $wallet) = @_;
    my $hash = $self->to_hash;
    $hash->{wallet_cid} = $hash->{id};
    if ($self->has_last_transaction_status && $self->last_transaction_status) {
        $hash->{error} = $self->last_transaction_status;
    }
    delete @{$hash}{qw/tries_num user_id id last_transaction_status/};  #информация внутренняя, не требуется снаружи

    $hash->{autopay_mode} = $wallet->autopay_mode if (defined $wallet);
    return $hash;
}

1;
